from tkinter import *
from tkinter import messagebox
from tkinter import simpledialog
import time
import random
import sys

tk = Tk()
msg = messagebox
sdg = simpledialog

#Global variables
bgColor = "grey"
squareColor = "black"
directionColor = "red"
conveyorBeltColor = "orange"
wallColor = "yellow"
playerColor = "gray25"
archiveMarkerColor = "blue"
pitInsideColor = "black"
pitColor = "gold"
laserColor = "red"
laserSourceColor = "brown"
flagColor = "green"
canvasW= 600
canvasH = 900
squareSize = canvasW/12
squares = [[]]

flags = []
conveyorBelts = []
walls = []
pits = []
lasers = []

#Create canvas
tk.geometry(str(canvasW) + "x" + str(canvasH) + "+0+0")
tk.title("Robo Rally")
canvas = Canvas(tk, width=canvasW, height=canvasH, bg=bgColor)
canvas.pack()

#Generate Grid
def grid():
    line = 0
    y = 0
    while y-squareSize <= canvasH:
        x = 0
        squares.append([]);
        while x-squareSize <= canvasW:
            squares[line].append(canvas.create_rectangle(x, y, x+squareSize, y+squareSize, outline=squareColor));
            x += squareSize
        y += squareSize
        line += 1

grid()

#Create Players
class Player:
    def __init__(self, x, y):
        self.x = x
        self.y = y
        self.archiveMarkerX = x
        self.archiveMarkerY = y
        self.previousX = 1
        self.previousY = 10
        x *= squareSize
        y *= squareSize
        archiveMarkerX = x
        archiveMarkerY = y
        self.archiveMarker = canvas.create_rectangle(archiveMarkerX, archiveMarkerY, archiveMarkerX+squareSize, archiveMarkerY+squareSize, outline=archiveMarkerColor)
        self.player = canvas.create_rectangle(x, y, x+squareSize, y+squareSize, fill=playerColor, outline=playerColor)
        self.directionIndicator = canvas.create_rectangle(x, y, x+squareSize, y+squareSize*0.2, fill=directionColor, outline=directionColor)
        self.direction = 1
        self.lives = 3
        self.state = 10
        self.flagTarget = 1
        self.number = 1
    def recreate(self, onArchiveMarker):
        if onArchiveMarker:
            self.x = self.archiveMarkerX
            self.y = self.archiveMarkerY
            x = self.x * squareSize
            y = self.y * squareSize
            canvas.delete(self.player)
            canvas.delete(self.directionIndicator)
            self.player = canvas.create_rectangle(x, y, x+squareSize, y+squareSize, fill=playerColor, outline=playerColor)
            self.directionIndicator = canvas.create_rectangle(x, y, x+squareSize, y+squareSize*0.2, fill=directionColor, outline=directionColor)
            self.changeDirection(0)
        else:
            self.x = self.previousX
            self.y = self.previousY
            x = self.x * squareSize
            y = self.y * squareSize
            canvas.delete(self.player)
            canvas.delete(self.directionIndicator)
            self.player = canvas.create_rectangle(x, y, x+squareSize, y+squareSize, fill=playerColor, outline=playerColor)
            self.directionIndicator = canvas.create_rectangle(x, y, x+squareSize, y+squareSize*0.2, fill=directionColor, outline=directionColor)
            self.changeDirection(0)
    def changeArchiveMarker(self, archiveMarkerX, archiveMarkerY):
        self.archiveMarkerX = archiveMarkerX
        self.archiveMarkerY = archiveMarkerY
        archiveMarkerX *= squareSize
        archiveMarkerY *= squareSize
        canvas.delete(self.archiveMarker)
        self.archiveMarker = canvas.create_rectangle(archiveMarkerX, archiveMarkerY, archiveMarkerX+squareSize, archiveMarkerY+squareSize, outline=archiveMarkerColor)
    def move(self, direction):
        self.previousX = self.x
        self.previousY = self.y
        if direction%4 == 1:
            canvas.move(self.player, 0, -squareSize)
            canvas.move(self.directionIndicator, 0, -squareSize)
            self.y -= 1
        elif direction%4 == 2:
            canvas.move(self.player, squareSize, 0)
            canvas.move(self.directionIndicator, squareSize, 0)
            self.x += 1
        elif direction%4  == 3:
            canvas.move(self.player, 0, squareSize)
            canvas.move(self.directionIndicator, 0, squareSize)
            self.y += 1
        else:
            canvas.move(self.player, -squareSize, 0)
            canvas.move(self.directionIndicator, -squareSize, 0)
            self.x -= 1
    def changeDirection(self, rotationAmount):
        self.direction += rotationAmount
        canvas.delete(self.directionIndicator)
        pos = canvas.coords(self.player)
        if self.direction%4 == 1:
            self.directionIndicator = canvas.create_rectangle(pos[0], pos[1], pos[2], pos[3]-squareSize*0.8, fill=directionColor, outline=directionColor)
        elif self.direction%4 == 2:
            self.directionIndicator = canvas.create_rectangle(pos[0]+squareSize*0.8, pos[1], pos[2], pos[3], fill=directionColor, outline=directionColor)
        elif self.direction%4 == 3:
            self.directionIndicator = canvas.create_rectangle(pos[0], pos[1]+squareSize*0.8, pos[2], pos[3], fill=directionColor, outline=directionColor)
        else:
            self.directionIndicator = canvas.create_rectangle(pos[0], pos[1], pos[2]-squareSize*0.8, pos[3], fill=directionColor, outline=directionColor)



#Create Objects

class Flags:
    def __init__(self, x, y, number):
        self.x = x
        self.y = y
        self.number = number
        x *= squareSize
        y *= squareSize
        self.flag = canvas.create_rectangle(x, y, x+squareSize, y+squareSize, fill=flagColor, outline=flagColor)
        self.flagLabel = canvas.create_text(x+squareSize*0.5, y+squareSize*0.5, text=number, font=("Purisa", 40))
    def playerOnFlag(self, thePlayer, number, check):
        if thePlayer.x == self.x and thePlayer.y == self.y:
            if self.number == number or not check:
                canvas.itemconfigure(self.flagLabel, fill="white")
                return True
        return False
    
class ConveyorBelts:
    def __init__(self, x, y, directionInput):
        self.x = x
        self.y = y
        x *= squareSize
        y *= squareSize
        self.conveyorBeltBG = canvas.create_rectangle(x, y, x+squareSize, y+squareSize, outline=conveyorBeltColor, fill=squareColor)
        self.direction = directionInput
        if self.direction == 1:
            self.conveyorBelt = canvas.create_polygon(x+squareSize*0.6, y+squareSize*0.8, x+squareSize*0.6, y+squareSize*0.4, x+squareSize*0.8, y+squareSize*0.4, x+squareSize*0.5, y+squareSize*0.1, x+squareSize*0.2, y+squareSize*0.4, x+squareSize*0.4, y+squareSize*0.4, x+squareSize*0.4, y+squareSize*0.8, outline=conveyorBeltColor, fill=conveyorBeltColor)
        elif self.direction == 2:
            self.conveyorBelt = canvas.create_polygon(x+squareSize*0.2, y+squareSize*0.4, x+squareSize*0.6, y+squareSize*0.4, x+squareSize*0.6, y+squareSize*0.2, x+squareSize*0.9, y+squareSize*0.5, x+squareSize*0.6, y+squareSize*0.8, x+squareSize*0.6, y+squareSize*0.6, x+squareSize*0.2, y+squareSize*0.6, outline=conveyorBeltColor, fill=conveyorBeltColor)
        elif self.direction == 3:
            self.conveyorBelt = canvas.create_polygon(x+squareSize*0.4, y+squareSize*0.2, x+squareSize*0.4, y+squareSize*0.6, x+squareSize*0.2, y+squareSize*0.6, x+squareSize*0.5, y+squareSize*0.9, x+squareSize*0.8, y+squareSize*0.6, x+squareSize*0.6, y+squareSize*0.6, x+squareSize*0.6, y+squareSize*0.2, outline=conveyorBeltColor, fill=conveyorBeltColor)
        else:
            self.conveyorBelt = canvas.create_polygon(x+squareSize*0.8, y+squareSize*0.4, x+squareSize*0.4, y+squareSize*0.4, x+squareSize*0.4, y+squareSize*0.2, x+squareSize*0.1, y+squareSize*0.5, x+squareSize*0.4, y+squareSize*0.8, x+squareSize*0.4, y+squareSize*0.6, x+squareSize*0.8, y+squareSize*0.6, outline=conveyorBeltColor, fill=conveyorBeltColor)
    def movePlayer(self, thePlayer):
        if thePlayer.x == self.x and thePlayer.y == self.y:
            thePlayer.move(self.direction)
            tk.update()
            time.sleep(wait)
            tk.update()
            return True

class Walls:
    def __init__(self, x, y, directionInput):
        self.x = x
        self.y = y
        x *= squareSize
        y *= squareSize
        self.invisibleX = self.x
        self.invisibleY = self.y
        self.direction = directionInput
        if self.direction == 1:
            self.wall = canvas.create_rectangle(x, y, x+squareSize, y+squareSize*0.1, outline=wallColor, fill=wallColor)
            self.invisibleY -= 1
        elif self.direction == 2:
            self.wall = canvas.create_rectangle(x+squareSize*0.9, y, x+squareSize, y+squareSize, outline=wallColor, fill=wallColor)
            self.invisibleX += 1
        elif self.direction == 3:
            self.wall = canvas.create_rectangle(x, y+squareSize*0.9, x+squareSize, y+squareSize, outline=wallColor, fill=wallColor)
            self.invisibleY += 1
        else:
            self.wall = canvas.create_rectangle(x, y, x+squareSize*0.1, y+squareSize, outline=wallColor, fill=wallColor)
            self.invisibleX -= 1
    def recreate(self):
        x = self.x * squareSize
        y = self.y * squareSize
        canvas.delete(self.wall)
        if self.direction == 1:
            self.wall = canvas.create_rectangle(x, y, x+squareSize, y+squareSize*0.1, outline=wallColor, fill=wallColor)
        elif self.direction == 2:
            self.wall = canvas.create_rectangle(x+squareSize*0.9, y, x+squareSize, y+squareSize, outline=wallColor, fill=wallColor)
        elif self.direction == 3:
            self.wall = canvas.create_rectangle(x, y+squareSize*0.9, x+squareSize, y+squareSize, outline=wallColor, fill=wallColor)
        else:
            self.wall = canvas.create_rectangle(x, y, x+squareSize*0.1, y+squareSize, outline=wallColor, fill=wallColor)
    def stopPlayer(self, thePlayer):
        if thePlayer.x == self.x and thePlayer.y == self.y:
            return 1
        elif thePlayer.x == self.invisibleX and thePlayer.y == self.invisibleY:
            return 2
        else:
            return 0

class Pits:
    def __init__(self, x, y):
        self.x = x
        self.y = y
        x *= squareSize
        y *= squareSize
        self.pit = canvas.create_rectangle(x, y, x+squareSize, y+squareSize, outline=pitColor, fill=pitColor)
        self.pitInside = canvas.create_rectangle(x+squareSize*0.1, y+squareSize*0.1, x+squareSize*0.9, y+squareSize*0.9, outline=pitInsideColor, fill=pitInsideColor)
    def playerOnPit(self, thePlayer):
        if thePlayer.x == self.x and thePlayer.y == self.y:
            return True
        return False

class Lasers:
    def __init__(self, x, y):
        self.x = x
        self.y = y
        x *= squareSize
        y *= squareSize        
        self.laserSource = canvas.create_rectangle(x+squareSize*0.8, y+squareSize*0.4, x+squareSize, y+squareSize*0.6, outline=laserSourceColor, fill=laserSourceColor)        
    def fire(self, thePlayer):
        x = self.x * squareSize
        y = self.y * squareSize
        previousWall = 0
        for wall in walls:
            if wall.x < self.x and wall.x > previousWall and wall.y == self.y:
                self.wallOnLine = wall
                previousWall = self.wallOnLine.x
        if thePlayer.x <= self.x and thePlayer.x >= self.wallOnLine.x and self.wallOnLine.y == thePlayer.y:
            self.playerOnLaser = True
            self.lenght = player.x + 1
        else:
            self.playerOnLaser = False
            self.lenght = self.wallOnLine.x + 0.1
        lenght = self.lenght * squareSize
        self.laser = canvas.create_line(x+squareSize*0.8, y+squareSize*0.5, lenght, y+squareSize*0.5, fill=laserColor)

#Generate Conveyor Belts Randomly
def conveyorBeltsGenerator():
    for n in range(random.randint(0, 50)):
        append = True
        randomX = random.randint(0, 11)
        randomY = random.randint(0, 11)
        for conveyorBelt in conveyorBelts:
            if randomX == conveyorBelt.x and randomY == conveyorBelt.y:
                append = False
                print(str(randomX) + "   " + str(conveyorBelt.x))
        if append:
            conveyorBelts.append(ConveyorBelts(randomX, randomY, random.randint(1, 4)))

def dockingBayA(x, y):
    #Conveyor Belts-----------------------------------------------------------
    for n in range(3):
        conveyorBelts.append(ConveyorBelts(x+n+2, y+3, 2)) #Bottom Left 
        conveyorBelts.append(ConveyorBelts(x+9-n, y+3, 4)) #Bottom Right
    for n in range(2):
        conveyorBelts.append(ConveyorBelts(x+n, y+2, 2)) #Top Left
        conveyorBelts.append(ConveyorBelts(x+11-n, y+2, 4)) #Top Right
    conveyorBelts.append(ConveyorBelts(x+2, y+2, 3)) #Down Left
    conveyorBelts.append(ConveyorBelts(x+9, y+2, 3)) #Down Right

    #Walls--------------------------------------------------------------------
    walls.append(Walls(x+2, y, 1)) #Top 1
    walls.append(Walls(x+4, y, 1)) #Top 2 A
    walls.append(Walls(x+7, y, 1)) #Top 3 A
    walls.append(Walls(x+9, y, 1)) #Top 4
    walls.append(Walls(x+4, y, 0)) #Top 2 B
    walls.append(Walls(x+7, y, 2)) #Top 3 B
    walls.append(Walls(x+1, y+1, 0)) #Left A
    walls.append(Walls(x+10, y+1, 2)) #Right A
    walls.append(Walls(x+2, y+1, 0)) #Left B
    walls.append(Walls(x+9, y+1, 2)) #Right B

def exchange(x, y):
    #Flags--------------------------------------------------------------------
    flags.append(Flags(7, 1, 1))
    flags.append(Flags(9, 7, 2))
    flags.append(Flags(1, 4, 3))
    
    #Conveyor Belts-----------------------------------------------------------
    for n in range(5):
        #Factory Floor
        conveyorBelts.append(ConveyorBelts(x+5, y+n, 3)) #Top Cross
        conveyorBelts.append(ConveyorBelts(x+6, y+n, 1)) #Top Cross
        conveyorBelts.append(ConveyorBelts(x+n+7, y+5, 4)) #Right Cross
        conveyorBelts.append(ConveyorBelts(x+n+7, y+6, 2)) #Right Cross
        conveyorBelts.append(ConveyorBelts(x+5, y+n+7, 3)) #Bottom Cross
        conveyorBelts.append(ConveyorBelts(x+n, y+5, 4)) #Left Cross
    for n in range(4):
        #Factory Floor
        conveyorBelts.append(ConveyorBelts(x+6, y+n+7, 1)) #Bottom Cross
        conveyorBelts.append(ConveyorBelts(x+n+1, y+6, 2)) #Left Cross
        conveyorBelts.append(ConveyorBelts(x+8, y+n, 3)) #Top Right Corner
    for n in range(3):
        #Factory Floor
        conveyorBelts.append(ConveyorBelts(x+n, y+3, 2)) #Top Left Corner
        conveyorBelts.append(ConveyorBelts(x+3, y+n, 1)) #Top Left Corner
        conveyorBelts.append(ConveyorBelts(x+9+n, y+3, 2)) #Top Right Corner
        conveyorBelts.append(ConveyorBelts(x+n, y+8, 4)) #Bottom Left Corner
        conveyorBelts.append(ConveyorBelts(x+3, y+9+n, 1)) #Bottom Left Corner
        conveyorBelts.append(ConveyorBelts(x+11-n, y+8, 4)) #Bottom Right Corner
        conveyorBelts.append(ConveyorBelts(x+8, 9+n, y+3)) #Bottom Right Corner

    #Factory Floor
    conveyorBelts.append(ConveyorBelts(x, y+1, 4)) #Top Left Small Corner
    conveyorBelts.append(ConveyorBelts(x+10, y, 1)) #Top Right Small Corner
    conveyorBelts.append(ConveyorBelts(x+11, y+1, 4)) #Top Right Small Corner
    conveyorBelts.append(ConveyorBelts(x+11, y+10, 2)) #Bottom Right Small Corner
    conveyorBelts.append(ConveyorBelts(x+10, y+11, 1)) #Bottom Right Small Corner

    #Walls--------------------------------------------------------------------
    walls.append(Walls(x+4, y+4, 2)) #Cross Top Left
    walls.append(Walls(x+4, y+4, 3)) #Cross Top Left
    walls.append(Walls(x+7, y+4, 0)) #Cross Top Right
    walls.append(Walls(x+7, y+4, 3)) #Cross Top Right
    walls.append(Walls(x+4, y+7, 2)) #Cross Bottom Left
    walls.append(Walls(x+4, y+7, 1)) #Cross Bottom Left
    walls.append(Walls(x+7, y+7, 0)) #Cross Bottom Right
    walls.append(Walls(x+7, y+7, 1)) #Cross Bottom Right
    walls.append(Walls(x, y+2, 0)) #Left 1
    walls.append(Walls(x, y+4, 0)) #Left 2
    walls.append(Walls(x, y+7, 0)) #Left 3
    walls.append(Walls(x, y+9, 0)) #Left 4
    walls.append(Walls(x+2, y, 1)) #Top 1
    walls.append(Walls(x+4, y, 1)) #Top 2
    walls.append(Walls(x+7, y, 1)) #Top 3
    walls.append(Walls(x+9, y, 1)) #Top 4
    walls.append(Walls(x+11, y+2, 2)) #Right 1
    walls.append(Walls(x+11, y+4, 2)) #Right 2
    walls.append(Walls(x+11, y+7, 2)) #Right 3
    walls.append(Walls(x+11, y+9, 2)) #Right 4
    walls.append(Walls(x+2, y+11, 3)) #Bottom 1
    walls.append(Walls(x+4, y+11, 3)) #Bottom 2
    walls.append(Walls(x+7, y+11, 3)) #Bottom 3
    walls.append(Walls(x+9, y+11, 3)) #Bottom 4
    walls.append(Walls(x+9, y+2, 0)) #Top Right
    walls.append(Walls(x+10, y+9, 1)) #Bottom Right
    walls.append(Walls(x+1, y+10, 3)) #Bottom Left

    #Pits---------------------------------------------------------------------
    pits.append(Pits(x+2, y+1)) #Top Left
    pits.append(Pits(x, y+10)) #Bottom Left
    
    #Lasers-------------------------------------------------------------------
    lasers.append(Lasers(11, 2))

def edges(x, y, width, height):
    for n in range(width):
        pits.append(Pits(x, n)) #Left
        pits.append(Pits(x+width, n)) #Right
    for n in range(height):
        pits.append(Pits(n, y)) #Top
        pits.append(Pits(n, y+height)) #Bottom

exchange(0, 0)
dockingBayA(0, 12)
edges(-1, -1, 13, 18)

player1 = Player(10, 2)
player = player1

wait = 0.5

def forward():
    player.move(player.direction)

def backward():
    player.move(player.direction+2)

def turnRight():
    player.changeDirection(1)

def turnLeft():
    player.changeDirection(3)

def uTurn():
    player.changeDirection(2)

def none():
    pass

def updateCanvas():
    pass

tk.update()

moves = {"F":forward, "B":backward, "L":turnLeft, "R":turnRight, "U":uTurn, "N":none}
movesChoser = {"F":forward, "B":backward, "L":turnLeft, "R":turnRight, "U":uTurn}

def getProgram():
    global moves, registers
    program = []
    deckGen = []

    canvas.itemconfigure(stateLabel, text="Damage: " + str(10-player.state))
    
    for cardNumber in range(player.state-1):
        cardName, cardCommand = random.choice(list(movesChoser.items()))
        deckGen.append(cardName)

    deck = tuple(deckGen)

    if player.state <= 5:
        registers = player.state-1
    else:
        registers = 5

    while len(program) != registers or len(cards) != player.state-1-registers:
        cards = list(deck)
        writtenProgram = sdg.askstring("Program Robot", cards)
        program = list(writtenProgram)

        cardAllreadyRemoved = False
        
        for command in program:
            for card in cards:
                if command == card and cardAllreadyRemoved == False:
                    cards.remove(card)
                    break

    while len(program) != 5:
        program.append("N")
    return program

usedCommands = []

programLabel = canvas.create_text(canvasW/2, 50, text="", fill="white", font=("Purisa", 70))
stateLabel = canvas.create_text(canvasW/2, canvasH-150, text="", fill="white", font=("Purisa", 70))

def recreateWalls():
    for wall in walls:
        wall.recreate()

def execute():
    for command in program:
        usedCommands.append(command)
        canvas.itemconfigure(programLabel, text=usedCommands)
        stop = False
        for wall in walls:
            if wall.stopPlayer(player) == 1 and ((command == "F" and player.direction%4 == wall.direction) or (command == "B" and (player.direction+2)%4 == wall.direction)):
                stop = True
                break
            elif wall.stopPlayer(player) == 2 and ((command == "B" and player.direction%4 == wall.direction) or (command == "F" and (player.direction+2)%4 == wall.direction)):
                stop = True
        if stop == False:
            move = moves.get(command)
            move()
        recreateWalls()
        tk.update()
        time.sleep(wait)
        tk.update()
        for flag in flags:
            isOnFlag = flag.playerOnFlag(player, player.number, True)
            if isOnFlag:
                player.changeArchiveMarker(flag.x, flag.y)
                player.number += 1
        for conveyorBelt in conveyorBelts:
            allreadyMoved = conveyorBelt.movePlayer(player)
            if allreadyMoved:
                break
        for pit in pits:
            isOnPit = pit.playerOnPit(player)
            if isOnPit:
                player.lives -= 1
                player.state -= 2
                player.recreate(True)
                recreateWalls()
                tk.update()
                return
        for laser in lasers:
            laser.fire(player)
            if laser.playerOnLaser:
                player.state -= 1
                recreateWalls()
        canvas.itemconfigure(stateLabel, text="Damage: " + str(10-player.state))
        tk.update()
        time.sleep(wait)
        for laser in lasers:
            canvas.delete(laser.laser)
        tk.update()
        time.sleep(wait)

while player.lives > 0:
    while player.state > 0 and player.lives > 0:
        program = getProgram()
        execute()
        for flag in flags:
            isOnFlag = flag.playerOnFlag(player, player.number, False)
            if isOnFlag and player.state < 9:
                player.state += 1
    player.lives -= 1
    player.state = 10
    canvas.itemconfigure(stateLabel, text="Damage: " + str(10-player.state))

canvas.itemconfigure(programLabel, text="Error Executing Program!")
canvas.itemconfigure(stateLabel, text="Shutting Down System!")
