from tkinter import *
from firebase import firebase
import random
import math
import time
import sys

tk = Tk()
firebase = firebase.FirebaseApplication('https://professional-9069c.firebaseio.com/', None)

#Generate canvas
canvasW = 800
canvasH = 800
squareSize = 100

tk.geometry(str(canvasW) + "x" + str(canvasH) + "+0+0")
tk.title("Professional")
canvas = Canvas(tk, width=canvasW, height=canvasH)
canvas.pack()

#Create diplomas
diplomas = {"CQP": [1, 500],
            "DEES": [1, 5000],
            "CAPES": [2, 750],
            "DSAA": [2, 750],
            "CAP": [2, 1000],
            "DEUST": [2, 1500],
            "DUT": [2, 1500],
            "DFASM": [8, 500]}

#Create News cards
#type price change   --> [nombre de joueurs, type de carte News, operation]
#type money transfer --> [nombre de joueurs, type de carte News, metier requis, montant a gagner/perdre]
cards = ([3, "Il n'y a plus de petrole. Les entreprises petrolieres ferment leurs portes. Votre revenu passe a $%d.", "income change", "changeIncome('Directeur Entreprise Petroliere', 'DirecteurEntreprisePetroliereIncome*=0')"],
         [2, "La fusion nucleaire marche officiellement et sera mise en place d'ici l'annee prochaine. Si vous etes scientifique, touchez $20000.", "money transfer", "Scientifique", 20000],
         [3, "Le terroriste Humis Berg a finalement ete retrouve. Les policiers touchent $2000.", "money transfer", "Policier", 2000],
         [2, "A cause de l'urbanisation, le prix moyen d'une location d'appartement a gravement augmente. Il represente aujourd'hui 1,5 fois plus qu'auparavant, ce qui fait $%d le mois.", "income change", "changeIncome('Agent Immobilier', 'AgentImmobilierIncome*=1.5')"],
         [2, "Nous sommes en pleine periode de vacances. A cause d'une hausse du tourisme, le prix moyen d'une nuit a l'hotel est multiplie par 1,5, ce qui fait $%d la nuit.", "income change", "changeIncome('Hotelier', 'HotelierIncome*=1.5')"],
         [2, "La nourriture se fait rare a cause d'un manque d'eau. Les agriculteurs eleveurs vendent maintenant leurs produits 2 fois plus chers qu'avant. Ils coutent $%d.", "income change", "changeIncome('Agriculteur Eleveur', 'AgriculteurEleveurIncome*=2')"],
         [2, "Il y a trop de candidats au poste de professeur. Le prix pour aller etudier est multiplie par 1,3. Tous les prix des formations sont multiplies par %d.", "income change", "changeIncome('Professeur', 'ProfesseurIncome+=1.3')"],
         [2, "Votre banquier vous ordonne de payer une dette que vous aviez faite durant votre jeunesse. Vous payez $5000.", "money transfer", "none required", -5000],
         [3, "Le gouvernement, pour empecher que les dirigeants de casino s'enrichissent trop, ordonne que tout ceux qui ont plus de deux casinos payent une amande de $8000.", "money transfer", "DirigeantCasino", -8000],
         [3, "Un grand virus s'est propage. Le gouvernement ordonne aux medecins de baisser leurs consultations de $100. Le cout pour se faire soigner fait donc maintenant $%d.", "income change", "changeIncome('Medecin Chirurgien Income', 'MedecinChirurgienIncome-=100')"],
         [2, "Il y a de plus en plus d'entrepreneurs. Il devient plus difficile de realiser ses projets. Tous les entrepreneurs doivent tomber %d fois sur le chiffre 7.", "income change", "changeIncome('Entrepreneur', 'EntrepreneurSameNumbers=6')"],
         [2, "Attaque terroriste en Inde. Si vous etes journaliste, vous gagnez $2000 en plus de vos $1000 pour avoir fait ce scoop.", "money transfer", "Journaliste", 2000],
         [2, "A cause des dernieres attaques terroristes, les gens partent. Le prix moyen d'une location d'appartement diminue. Il baisse de $100. Il represente aujourd'hui $%d le mois.", "income change", "changeIncome('Agent Immobilier', 'AgentImmobilierIncome-=100')"],
         [2, "Le tourisme baisse legerement, le prix moyen d'une nuit a l'hotel diminue de $10. Il represente aujourd'hui $%d la nuit.", "income change", "changeIncome('Hotelier', 'HotelierIncome-=10')"],
         [2, "Une nouvelle espece animal a ete decouverte. Si vous etes scientifique, touchez $10000.", "money transfer", "Scientifique", 10000],
         [3, "Il y a de moins en moins de malades. Les medecins augmentent leurs prix de $500 pour ne pas faire fallite. Vous devez maintenant payer $%d.", "income change", "changeIncome('Medecin Chirurgien', 'MedecinChirurgienIncome+=500')"],
         [3, "Un nouveau forage a detecter un gisement de petrole. Les entreprises petrolieres reprennent leurs activites. Vous vendez a nouveau votre petrole $%d.", "income change", "changeIncome('Directeur Entreprise Petroliere', 'DirecteurEntreprisePetroliereIncome+=8000')"],
         [2, "Si vous etes artiste, vous touchez $10000 d'un riche milliardaire qui veut decorer son manoir avec vos oeuvres.", "money transfer", "Artiste", 10000],
         [3, "Votre pere est mort. Vous touchez une partie de son heritage, ce qui fait que vous gagnez $15000.", "money transfer", "none required", 15000],
         [3, "Vous touchez $10000 de votre voiture que vous avez vendu.", "money transfer", "none required", 10000],
         [2, "Vous touchez $8000 de la lotterie.", "money transfer", "none required", 8000],
         [2, "Vous touchez $4000 de la lotterie.", "money transfer", "none required", 4000],
         [2, "Vous etes interviewer pour un documentaire. Touchez $1500.", "money transfer", "none required", 1500],
         [2, "Si vous etes entrepreneur et que vous avez deja realise un projet, vous venez d'avoir l'idee du siecle. Touchez $12000.", "money transfer", "Entrepreneur", 12000])

#Player class
class Player:
    def __init__(self, name, turn):
        self.name = name
        self.turn = turn
        self.jobs = []
    def read(self):
        self.money = firebase.get('/Players/%s' % self.name, "Money")
        self.jailTime = firebase.get('/Players/%s' % self.name, "Jail Time")
        self.oldJobs = self.jobs
        self.jobs = firebase.get('/Players/%s' % self.name, "Jobs")
        self.diplomas = firebase.get('/Players/%s' % self.name, "Diplomas")
        self.diplomaInFormation = firebase.get('/Players/%s' % self.name, "Diploma In Formation")
        self.monthlyPayments = firebase.get('/Players/%s' % self.name, "Monthly Payments")
        if self.jobs == None:
            self.jobs = []
        else:
            self.jobs = list(self.jobs)
            for jobNotFormatted in self.jobs:
                job = jobNotFormatted.split(",")
                job = list(map(int, job))
                self.jobs[self.jobs.index(jobNotFormatted)] = job
                if job not in self.oldJobs:
                    x = job[0]-1
                    y = job[1]-1
                    canvas.create_rectangle(x*squareSize+squareSize*0.1, y*squareSize+squareSize*0.7, x*squareSize+squareSize*0.9, y*squareSize+squareSize*0.9, fill="black")
                    square.text = canvas.create_text(x*squareSize+squareSize*0.5, y*squareSize+squareSize*0.8, text=self.name, fill="white", font=("Purisa", 14))
                    tk.update()
        if self.diplomas == None:
            self.diplomas = {}
        if self.diplomaInFormation == None:
            self.diplomaInFormation = {}
        if self.monthlyPayments == None:
            self.monthlyPayments = {}
    def write(self):
        firebase.put('/Players/%s' % self.name, "Money", self.money)
        firebase.put('/Players/%s' % self.name, "Jail Time", self.jailTime)
        for value in self.jobs:
            value = "%s,%s" % (value[0], value[1])
            firebase.put('/Players/%s/Jobs' % self.name, str(value), "")
        for value in self.diplomas:
            firebase.put('/Players/%s/Diplomas' % self.name, str(self.diplomas.index(value)), value)
        for value in self.diplomaInFormation:
            firebase.put('/Players/%s/Diploma In Formation' % self.name, str(self.diplomaInFormation.index(value)), value)
        for value in self.monthlyPayments:
            firebase.put('/Players/%s/Monthly Payments' % self.name, str(self.monthlyPayments.index(value)), value)

#Generate players
players = []

print("\n"*50)

while True:
    name = input("Votre nom d'utilisateur : ")
    if name == "":
        print("Vous n'avez pas rentre de nom.")
    elif len(name) > 8:
        print("Ce nom est trop long. Il doit faire maximum 8 characteres.")
    else:
        break
firebase.put('/Players/%s' % name, "Money", 30000)
firebase.put('/Players/%s' % name, "Jail Time", 0)
print("Recherche d'autres joueurs...")
time.sleep(5)
playerNames = firebase.get('/Players', None)
sortedPlayerNames=sorted(playerNames.keys(), key=lambda x:x.lower())
playerTurn = 0
for playerName in sortedPlayerNames:
    players.append(Player(playerName, playerTurn))
    playerTurn += 1
print("\n"*50)
for player in players:
    player.read()
print("%d autres joueurs trouves." % (len(players)-1))

#Squares classes

class Prison:
    def __init__(self):
        self.name = "Prison"
        self.price = "not buyable"
    def generate(self, x, y):
        self.x = x
        self.y = y
        self.photo = PhotoImage(file="img/prison.gif")
        canvas.create_image(x*squareSize, y*squareSize, anchor=NW, image=self.photo)
        canvas.create_rectangle(x*squareSize, y*squareSize, x*squareSize+squareSize, y*squareSize+squareSize, width=7)

class ArgentTrouve:
    def __init__(self):
        self.name = "Argent Trouve"
        self.price = "not buyable"
    def generate(self, x, y):
        self.x = x
        self.y = y
        self.photo = PhotoImage(file="img/argentTrouve.gif")
        canvas.create_image(x*squareSize, y*squareSize, anchor=NW, image=self.photo)
        canvas.create_rectangle(x*squareSize, y*squareSize, x*squareSize+squareSize, y*squareSize+squareSize, width=7)

class Tunnel:
    def __init__(self):
        self.name = "Tunnel"
        self.price = "not buyable"
    def generate(self, x, y):
        self.x = x
        self.y = y
        self.photo = PhotoImage(file="img/tunnel.gif")
        canvas.create_image(x*squareSize, y*squareSize, anchor=NW, image=self.photo)
        canvas.create_rectangle(x*squareSize, y*squareSize, x*squareSize+squareSize, y*squareSize+squareSize, width=7)

AgriculteurEleveurIncome = squareSize
class AgriculteurEleveur:
    def __init__(self):
        self.name = "Agriculteur Eleveur"
        self.price = 4000
        self.incomeType = "per customer"
        self.income = AgriculteurEleveurIncome
        self.diploma = "none required"
        self.owner = "no owner"
        self.star = False
    def generate(self, x, y):
        self.x = x
        self.y = y
        self.photo = PhotoImage(file="img/agriculteurEleveur.gif")
        canvas.create_image(x*squareSize, y*squareSize, anchor=NW, image=self.photo)
        canvas.create_rectangle(x*squareSize, y*squareSize, x*squareSize+squareSize, y*squareSize+squareSize, width=7)
    def addToDatabase(self):
        firebase.put('/Board/%d/%d' % (self.x, self.y), "Income", self.income)
        firebase.put('/Board/%d/%d' % (self.x, self.y), "Owner", "no owner")
        firebase.put('/Board/%d/%d' % (self.x, self.y), "Star", False)
    def update(self):
        self.income = AgriculteurEleveurIncome
    def write(self):
        firebase.put('/Board/%d/%d' % (self.x, self.y), "Owner", self.owner.turn)
        firebase.put('/Board/%d/%d' % (self.x, self.y), "Star", self.star)
        
ScientifiqueIncome = 50
class Scientifique:
    def __init__(self):
        self.name = "Scientifique"
        self.price = 600
        self.incomeType = "per customer"
        self.income = ScientifiqueIncome
        self.diploma = "DEUST"
        self.owner = "no owner"
        self.star = False
    def generate(self, x, y):
        self.x = x
        self.y = y
        self.photo = PhotoImage(file="img/scientifique.gif")
        canvas.create_image(x*squareSize, y*squareSize, anchor=NW, image=self.photo)
        canvas.create_rectangle(x*squareSize, y*squareSize, x*squareSize+squareSize, y*squareSize+squareSize, width=7)
    def addToDatabase(self):
        firebase.put('/Board/%d/%d' % (self.x, self.y), "Income", self.income)
        firebase.put('/Board/%d/%d' % (self.x, self.y), "Owner", "no owner")
        firebase.put('/Board/%d/%d' % (self.x, self.y), "Star", False)
    def update(self):
        self.income = ScientifiqueIncome
    def write(self):
        firebase.put('/Board/%d/%d' % (self.x, self.y), "Owner", self.owner.turn)
        firebase.put('/Board/%d/%d' % (self.x, self.y), "Star", self.star)
        
JournalisteIncome = 100
class Journaliste:
    def __init__(self):
        self.name = "Journaliste"
        self.price = 0
        self.incomeType = "by bank per customer"
        self.income = JournalisteIncome
        self.diploma = "DUT"
        self.owner = "no owner"
        self.star = False
    def generate(self, x, y):
        self.x = x
        self.y = y
        self.photo = PhotoImage(file="img/journaliste.gif")
        canvas.create_image(x*squareSize, y*squareSize, anchor=NW, image=self.photo)
        canvas.create_rectangle(x*squareSize, y*squareSize, x*squareSize+squareSize, y*squareSize+squareSize, width=7)
    def addToDatabase(self):
        firebase.put('/Board/%d/%d' % (self.x, self.y), "Income", self.income)
        firebase.put('/Board/%d/%d' % (self.x, self.y), "Owner", "no owner")
        firebase.put('/Board/%d/%d' % (self.x, self.y), "Star", False)
    def update(self):
        self.income = JournalisteIncome
    def write(self):
        firebase.put('/Board/%d/%d' % (self.x, self.y), "Owner", self.owner.turn)
        firebase.put('/Board/%d/%d' % (self.x, self.y), "Star", self.star)

AgentImmobilierIncome = 1500
class AgentImmobilier:
    def __init__(self):
        self.name = "Agent Immobilier"
        self.price = 15000
        self.incomeType = "per customer per month"
        self.income = AgentImmobilierIncome
        self.diploma = "DEUST"
        self.owner = "no owner"
        self.star = False
        self.customer = "no customer"
    def generate(self, x, y):
        self.x = x
        self.y = y
        self.photo = PhotoImage(file="img/agentImmobilier.gif")
        canvas.create_image(x*squareSize, y*squareSize, anchor=NW, image=self.photo)
        canvas.create_rectangle(x*squareSize, y*squareSize, x*squareSize+squareSize, y*squareSize+squareSize, width=7)
    def addToDatabase(self):
        firebase.put('/Board/%d/%d' % (self.x, self.y), "Income", self.income)
        firebase.put('/Board/%d/%d' % (self.x, self.y), "Owner", "no owner")
        firebase.put('/Board/%d/%d' % (self.x, self.y), "Star", False)
    def update(self):
        self.income = AgentImmobilierIncome
    def write(self):
        firebase.put('/Board/%d/%d' % (self.x, self.y), "Owner", self.owner.turn)
        firebase.put('/Board/%d/%d' % (self.x, self.y), "Star", self.star)
        
ProfesseurIncome = 1
class Professeur:
    def __init__(self):
        self.name = "Professeur"
        self.price = 0
        self.incomeType = "per customer per month by diploma"
        self.income = ProfesseurIncome
        self.diploma = "CAPES"
        self.owner = "no owner"
        self.star = False
    def generate(self, x, y):
        self.x = x
        self.y = y
        self.photo = PhotoImage(file="img/professeur.gif")
        canvas.create_image(x*squareSize, y*squareSize, anchor=NW, image=self.photo)
        canvas.create_rectangle(x*squareSize, y*squareSize, x*squareSize+squareSize, y*squareSize+squareSize, width=7)
    def addToDatabase(self):
        firebase.put('/Board/%d/%d' % (self.x, self.y), "Income", self.income)
        firebase.put('/Board/%d/%d' % (self.x, self.y), "Owner", "no owner")
        firebase.put('/Board/%d/%d' % (self.x, self.y), "Star", False)
    def update(self):
        self.income = ProfesseurIncome
    def write(self):
        firebase.put('/Board/%d/%d' % (self.x, self.y), "Owner", self.owner.turn)
        firebase.put('/Board/%d/%d' % (self.x, self.y), "Star", self.star)
        
HotelierIncome = 100
class Hotelier:
    def __init__(self):
        self.name = "Hotelier"
        self.price = 4000
        self.incomeType = "per customer by number"
        self.income = HotelierIncome
        self.diploma = "none required"
        self.owner = "no owner"
        self.star = False
    def generate(self, x, y):
        self.x = x
        self.y = y
        self.photo = PhotoImage(file="img/hotelier.gif")
        canvas.create_image(x*squareSize, y*squareSize, anchor=NW, image=self.photo)
        canvas.create_rectangle(x*squareSize, y*squareSize, x*squareSize+squareSize, y*squareSize+squareSize, width=7)
    def addToDatabase(self):
        firebase.put('/Board/%d/%d' % (self.x, self.y), "Income", self.income)
        firebase.put('/Board/%d/%d' % (self.x, self.y), "Owner", "no owner")
        firebase.put('/Board/%d/%d' % (self.x, self.y), "Star", False)
    def update(self):
        self.income = HotelierIncome
    def write(self):
        firebase.put('/Board/%d/%d' % (self.x, self.y), "Owner", self.owner.turn)
        firebase.put('/Board/%d/%d' % (self.x, self.y), "Star", self.star)

ArtisteIncome = 50
class Artiste:
    def __init__(self):
        self.name = "Artiste"
        self.price = 100
        self.incomeType = "per customer by number"
        self.income = ArtisteIncome
        self.diploma = "none required"
        self.owner = "no owner"
        self.star = False
    def generate(self, x, y):
        self.x = x
        self.y = y
        self.photo = PhotoImage(file="img/artiste.gif")
        canvas.create_image(x*squareSize, y*squareSize, anchor=NW, image=self.photo)
        canvas.create_rectangle(x*squareSize, y*squareSize, x*squareSize+squareSize, y*squareSize+squareSize, width=7)
    def addToDatabase(self):
        firebase.put('/Board/%d/%d' % (self.x, self.y), "Income", self.income)
        firebase.put('/Board/%d/%d' % (self.x, self.y), "Owner", "no owner")
        firebase.put('/Board/%d/%d' % (self.x, self.y), "Star", False)
    def update(self):
        if "DSAA" in self.owner.diplomas:
            self.income = ArtisteIncome*2
        else:
            self.income = ArtisteIncome
    def write(self):
        firebase.put('/Board/%d/%d' % (self.x, self.y), "Owner", self.owner.turn)
        firebase.put('/Board/%d/%d' % (self.x, self.y), "Star", self.star)

RestaurateurIncome = 100
class Restaurateur:
    def __init__(self):
        self.name = "Restaurateur"
        self.price = 1500
        self.incomeType = "per customer"
        self.income = RestaurateurIncome
        self.diploma = "none required"
        self.owner = "no owner"
        self.star = False
    def generate(self, x, y):
        self.x = x
        self.y = y
        self.photo = PhotoImage(file="img/restaurateur.gif")
        canvas.create_image(x*squareSize, y*squareSize, anchor=NW, image=self.photo)
        canvas.create_rectangle(x*squareSize, y*squareSize, x*squareSize+squareSize, y*squareSize+squareSize, width=7)
    def addToDatabase(self):
        firebase.put('/Board/%d/%d' % (self.x, self.y), "Income", self.income)
        firebase.put('/Board/%d/%d' % (self.x, self.y), "Owner", "no owner")
        firebase.put('/Board/%d/%d' % (self.x, self.y), "Star", False)
    def update(self):
        if "CQP" in self.owner.diplomas:
            self.income = RestaurateurIncome*2
        else:
            self.income = RestaurateurIncome
    def write(self):
        firebase.put('/Board/%d/%d' % (self.x, self.y), "Owner", self.owner.turn)
        firebase.put('/Board/%d/%d' % (self.x, self.y), "Star", self.star)

EntrepreneurIncome = 1500
EntrepreneurSameNumbers = 4
class Entrepreneur:
    def __init__(self):
        self.name = "Entrepreneur"
        self.price = 15000
        self.incomeType = "per customer after same numbers"
        self.income = EntrepreneurIncome
        self.entrepreneurSameNumbers = EntrepreneurSameNumbers
        self.sameNumbersTimes = 0
        self.diploma = "none required"
        self.owner = "no owner"
        self.star = False
    def generate(self, x, y):
        self.x = x
        self.y = y
        self.photo = PhotoImage(file="img/entrepreneur.gif")
        canvas.create_image(x*squareSize, y*squareSize, anchor=NW, image=self.photo)
        canvas.create_rectangle(x*squareSize, y*squareSize, x*squareSize+squareSize, y*squareSize+squareSize, width=7)
    def addToDatabase(self):
        firebase.put('/Board/%d/%d' % (self.x, self.y), "Income", self.income)
        firebase.put('/Board/%d/%d' % (self.x, self.y), "Entrepreneur Same Numbers", self.entrepreneurSameNumbers)
        firebase.put('/Board/%d/%d' % (self.x, self.y), "Same Numbers Times", self.sameNumbersTimes)
        firebase.put('/Board/%d/%d' % (self.x, self.y), "Owner", "no owner")
        firebase.put('/Board/%d/%d' % (self.x, self.y), "Star", False)
    def update(self):
        self.income = EntrepreneurIncome
        if "DEES" in self.owner.diplomas or "DUT" in self.owner.diplomas:
            self.entrepreneurSameNumbers = EntrepreneurSameNumbers/2
        else:
            self.entrepreneurSameNumbers = EntrepreneurSameNumbers/2
    def write(self):
        firebase.put('/Board/%d/%d' % (self.x, self.y), "Same Numbers Times", self.sameNumbersTimes)
        firebase.put('/Board/%d/%d' % (self.x, self.y), "Owner", self.owner.turn)
        firebase.put('/Board/%d/%d' % (self.x, self.y), "Star", self.star)

class News:
    def __init__(self):
        self.name = "News"
        self.price = "not buyable"
    def generate(self, x, y):
        self.x = x
        self.y = y
        self.photo = PhotoImage(file="img/news.gif")
        canvas.create_image(x*squareSize, y*squareSize, anchor=NW, image=self.photo)
        canvas.create_rectangle(x*squareSize, y*squareSize, x*squareSize+squareSize, y*squareSize+squareSize, width=7)

# Generate board
squares2Players = [Prison(),
                   Tunnel(), Tunnel(),
                   AgriculteurEleveur(), AgriculteurEleveur(),
                   Scientifique(), Scientifique(),
                   Journaliste(), Journaliste(),
                   AgentImmobilier(), AgentImmobilier(),
                   Professeur(), Professeur(),
                   ArgentTrouve(), ArgentTrouve(), ArgentTrouve(),
                   Hotelier(), Hotelier(), Hotelier(), Hotelier(),
                   Artiste(), Artiste(), Artiste(), Artiste(),
                   Restaurateur(), Restaurateur(), Restaurateur(), Restaurateur(),
                   Entrepreneur(), Entrepreneur(), Entrepreneur(), Entrepreneur(),
                   News(), News(), News(), News()]

squares3Players = []

squares4Players = []

numberPlayers = 2

print("Generation du plateau...")
if players[0].name == name:
    squares = squares2Players
    random.shuffle(squares)
    n = 0
    for square in squares:
        firebase.put('/Squares', str(n), square.name)
        n += 1
else:
    time.sleep(20)
    squares = []
    squaresNotFormatted = firebase.get('/Squares', None)
    for squareNotFormated in squaresNotFormatted:
        for square in squares2Players:
            if squareNotFormated == square.name:
                squares.append(square)
                squares2Players.remove(square)
                break
size = int(math.sqrt(len(squares)))
board = []
for y in range(size):
    board.append([])
    for x in range(size):
        n = y*size+x
        board[y].append(squares[n])
for y in range(size):
    for x in range(size):
        board[x][y].generate(x, y)
        if players[0].name == name and board[x][y].price != "not buyable":
            board[x][y].addToDatabase()
tk.update()
print("Plateau genere.")

deck = []

year = 1
month = 1
week = 0
firebase.put('/', 'Turn', 0)

def moneyTransfer(winningPlayer, amount):
    player.money -= amount
    print("Vous avez maintenant $%d." % player.money)
    winningPlayer.money += amount
    print("%s a maintenant $%d." % (winningPlayer.name, winningPlayer.money))

def checkFormations():
    for player in players:
        if player.diplomaInFormation != {}:
            if player.diplomaInFormation[2] == week and player.diplomaInFormation[3] == turn:
                player.diplomaInFormation[1] += 1
                if player.diplomaInFormation[1] > diplomas[player.diplomaInFormation[0]][0]:
                    player.diplomas[len(diplomas)] = player.diplomaInFormation[0]
                    print("Vous avez obtenu le diplome %s" % player.diplomaInFormation[0])
                    player.diplomaInFormation = {}
                else:
                    if player.diplomaInFormation[4] == "no owner":
                        player.money -= diplomas[diploma][1]
                        print("$%d a ete debite de votre compte banquaire pour votre formation. Il reste %d mois. Vous avez $%d." % (diplomas[diploma][1], diplomas[diploma][0]-player.diplomaInFormation[1]+1, player.money))
                    else:
                        if player == player.diplomaInFormation[4]:
                            print("Il reste %d mois de formation." % (diplomas[diploma][0]-player.diplomaInFormation[1]+1))
                        else:
                            print("Vous avez payez $%d a %s pour votre formation. Il reste %d mois." % (diplomas[diploma][1], player.diplomaInFormation[4].name, diplomas[diploma][0]-player.diplomaInFormation[1]+1))
                            moneyTransfer(player.diplomaInFormation[4], diplomas[diploma][1])

def checkMonthlyPayments():
    for player in players:
        for monthlyPayment in player.monthlyPayments:
            if monthlyPayment[2] == week and monthlyPayment[3] == turn:
                monthlyPayment[1] -= 1
                if monthlyPayment[1] == 0:
                    print("Vous avez finit de louer l'appartement de %s" % monthlyPayment[0].owner.name)
                    monthlyPayment[0].customer = "no customer"
                    player.monthlyPayments.remove(monthlyPayment)
                else:
                    print("Vous avez payez $%d a %s pour votre appartement." % (AgentImmobilierIncome, monthlyPayment[0].owner.name))
                    moneyTransfer(monthlyPayment[0].owner, AgentImmobilierIncome)

def checkEntrepreneur():
    for squareCoords in player.jobs:
        square = board[squareCoords[0]-1][squareCoords[1]-1]
        if square.name == "Entrepreneur":
            square.sameNumbersTimes += 1
            if square.sameNumbersTimes == square.entrepreneurSameNumbers:
                print("Vous avez realise un projet grace a votre case Entrepreneur %d,%d ! Vous touchez $10000." % (squareCoords[0], squareCoords[1]))
                player.money += 10000
                print("Vous avez maintenant $%d." % player.money)
            else:
                print("Votre projet de la case entrepreneur %d,%d est en train d'etre realise. Plus que %d fois des nombres pareilles et vous le realise." % (squareCoords[0], squareCoords[1], EntrepreneurSameNumbers-square.sameNumbersTimes))

def checkStar(squareToFind):
    squaresToFind = []
    for squareCoords in squareToFind.owner.jobs:
        square = board[squareCoords[0]-1][squareCoords[1]-1]
        if square.name == squareToFind.name:
            squaresToFind.append(square)
    if len(squaresToFind) >= 3:
        for squareCoords in squareToFind.owner.jobs:
            square = board[squareCoords[0]-1][squareCoords[1]-1]
            if square.name == squareToFind.name:
                newText = "* %s *" % player.name
                canvas.itemconfigure(square.text, text=newText)
                square.star = True
        tk.update()

def setupTurn():
    global year, month, week, turn
    turn = firebase.get('/Turn', None)
    if turn == 0:
        week += 1
    if week > 5:
        month += 1
        week = 1
    if month > 12:
        year += 1
        month = 1
    print("Annee %d, mois %d, semaine %d du mois" % (year, month, week))
    if players[turn].name == name:
        print("%s, c'est a votre tour." % players[turn].name)
    else:
        print("C'est au tour de %s." % players[turn].name)
        return players[turn]
    for player in players:
        player.read()
    checkFormations()
    checkMonthlyPayments()
    return players[turn]

def buySquare(squareX, squareY):
    x = squareX-1
    y = squareY-1
    square = board[x][y]
    price = square.price
    player.money -= price
    print("$%d a ete debite de votre compte banquaire. Vous avez $%d." % (square.price, player.money))
    square.owner = player
    player.jobs.append([squareX, squareY])
    canvas.create_rectangle(x*squareSize+squareSize*0.1, y*squareSize+squareSize*0.7, x*squareSize+squareSize*0.9, y*squareSize+squareSize*0.9, fill="black")
    square.text = canvas.create_text(x*squareSize+squareSize*0.5, y*squareSize+squareSize*0.8, text=player.name, fill="white", font=("Purisa", 14))
    tk.update()
    checkStar(square)
    print("Vous etes maintenant proprietaire de la case %s ayant les coordonnes %d,%d." % (square.name, squareX, squareY))

def startFormation():
    if player.diplomaInFormation != {}:
        print("Vous avez deja le diplome %s en formation." % (player.diplomaInFormation[0]))
        return
    while True:
        diploma = input("Initiales du diplome : ")
        if diploma in player.diplomas:
            print("Vous avez deja le diplome %s." % player.diplomas[0])
        else:
            break
    if square.owner == "no owner":
        player.money -= diplomas[diploma][1]
        print("Vous commencez une formation de %d mois pour obtenir le %s. $%d sera debite chaque mois au cours de la formation." % (diplomas[diploma][0], diploma, diplomas[diploma][1]))
        print("Vous avez $%d." % player.money)
    else:
        if player == square.owner:
            print("Vous commencez une formation de %d mois pour obtenir le %s gratuite car vous etes professeur." % (diplomas[diploma][0], diploma))
        else:
            print("Vous commencez une formation de %d mois pour obtenir le %s. $%d sera paye a %s chaque mois au cours de la formation." % (diplomas[diploma][0], diploma, diplomas[diploma][1], square.owner.name))
            moneyTransfer(square.owner, diplomas[diploma][1])
    player.diplomaInFormation = [diploma, 1, week, turn, square.owner]

def changeIncome(squareName, squareIncome):
    exec(squareIncome)
    newValue = eval(re.split(r'[`\-=~!@#$%^&*()_+\[\]{};\'\\:"|<,./<>?]', squareIncome)[0])
    for y in range(size):
        for x in range(size):
            if board[x][y].name == squareName:
                if squareName == "Entrepreneur":
                    firebase.put('/Board/%d/%d' % (x, y), "Entrepreneur Same Numbers", newValue)
                else:
                    firebase.put('/Board/%d/%d' % (x, y), "Income", newValue)
    print(news[1] % newValue)

while True:
    player = setupTurn()
    if player.name == name:
        if player.jailTime == 0:
            playerX = random.randint(1, 6)
            playerY = random.randint(1, 6)
            square = board[playerX-1][playerY-1]
            if square.price != "not buyable":
                ownerNumber = firebase.get('/Board/%d/%d' % (playerX-1, playerY-1), "Owner")
                if ownerNumber != "no owner":
                    square.owner = players[ownerNumber]
                    square.star = firebase.get('/Board/%d/%d' % (playerX, playerY), "Star")
            print("Vous etes sur la case %s ayant les coordonnes %d,%d." % (square.name, playerX, playerY))
            if playerX == playerY:
                checkEntrepreneur()
            if square.name == "Tunnel":
                while True:
                    squareCoordsStr = input("Rentrez les coordonnees de la case ou vous voulez aller : ")
                    squareCoords = list(map(int, squareCoordsStr.split(",")))
                    playerX = squareCoords[0]
                    playerY = squareCoords[1]
                    square = board[playerX-1][playerY-1]
                    if square.price != "not buyable":
                        ownerNumber = firebase.get('/Board/%d/%d' % (playerX-1, playerY-1), "Owner")
                        if ownerNumber != "no owner":
                            square.owner = players[ownerNumber]
                            square.star = firebase.get('/Board/%d/%d' % (playerX, playerY), "Star")
                        break
                    else:
                        print("Vous avez rentrez les coordonnees d'une case %s, mais ce n'est pas une case professions. Elle n'est donc pas reliee au reseau de tunnel.")
                print("Vous etes maintenant sur la case %s ayant les coordonnes %d,%d." % (square.name, playerX, playerY))
            if square.name == "Prison":
                player.jailTime = 3
                print("Vous etes prisonnie ! Vous devez rester en prison pendant 3 tours. Vous ne pourrez toucher de l'argent. Vous payez $500 d'amende.")
                player.money -= 500
                print("Vous avez maintenant $%d." % player.money)
                print(players[0].money)
            elif square.name == "Argent Trouve":
                amount = random.randrange(100, 3000, 100)
                print("Vous avez trouve $%d." % amount)
                player.money += amount
                print("Vous avez maintenant $%d." % player.money)
            elif square.name == "News":
                #Beginning getNews
                receivedNews = False
                while receivedNews == False:
                    if len(deck) == 0:
                        for card in cards:
                            if card[0] <= numberPlayers:
                                deck.append(card)
                    if len(deck) == 1:
                        news = deck[0]
                    else:
                        news = random.choice(deck)
                    if news[2] == "money transfer":
                        if news[3] == "none required":
                            print(news[1])
                            player.money += news[4]
                            print("Vous avez maintenant $%d." % player.money)
                            receivedNews = True
                        else:
                            for squareCoords in player.jobs:
                                square = board[squareCoords[0]-1][squareCoords[1]-1]
                                if news[3] == square.name:
                                    if receivedNews == False:
                                        print(news[1])
                                    player.money += news[4]
                                    print("Vous avez maintenant $%d." % player.money)
                                    receivedNews = True
                    else:
                        exec(news[3])
                        receivedNews = True
                    deck.remove(news)
                #End getNews
            elif square.owner == "no owner":
                if square.diploma == "none required" or square.diploma in player.diplomas:
                    answer = input("Voulez-vous acheter cette case ? ")
                    if answer == "Oui" or answer == "oui":
                        buySquare(playerX, playerY)
                else:
                    print("Pour devenir %s, vous avez besoin du diplome %s." % (square.name, square.diploma))
            else:
                if player == square.owner:
                    print("Vous etes chez vous.")
                elif square.owner.jailTime != 0:
                    print("%s est en prison, donc vous n'avez pas besoin de le payer." % square.owner.name)
                else:
                    square.update()
                    if square.star:
                        square.income *= 3
                    if square.incomeType == "per customer":
                        print("Vous devez payer $%d a %s." % (square.income, square.owner.name))
                        moneyTransfer(square.owner, square.income)
                    elif square.incomeType == "by bank per customer":
                        print("%s touche $%d car vous lui avez apporte des informations importantes." % square.owner.name)
                        square.owner.money += square.income
                        print("%s a maintenant $%d." % (square.owner.name, square.owner.money))
                    elif square.incomeType == "per customer per month":
                        if square.customer == "no customer":
                            square.customer = player
                            months = random.randint(1, 6)
                            print("Vous devez payer $%d a %s chaque mois pendant %d mois pour votre appartement." % (square.income, square.owner.name, months))
                            moneyTransfer(square.owner, square.income)
                            square.owner.monthlyPayments[len(monthlyPayments)] = [square, months, week, turn]
                    elif square.incomeType == "per customer by number":
                        amount = random.randint(1, 10)*square.income
                        print("Vous devez payer $%d a %s." % (amount, square.owner.name))
                        moneyTransfer(square.owner, amount)
                    elif square.incomeType == "per customer after same numbers":
                        if square.sameNumbersTimes >= 4:
                            print("Vous devez payer $%d a %s car son projet a ete realise." % (square.income, square.owner.name))
                            moneyTransfer(square.owner.name, square.income)
                        else:
                            print("%s n'a pas encore realise son projet, donc vous n'avez pas besoin de le payer." % square.owner.name)
            if square.name == "Professeur":
                startFormation()
        else:
            player.jailTime -= 1
            if player.jailTime > 0:
                print("Il vous reste %d tours de prison." % player.jailTime)
            else:
                print("Vous allez etre libere de prison au prochain tour.")
        input("Appuyez sur une touche pour terminer votre tour. ")
        for player2 in players:
            player2.write()
        for y in range(size):
            for x in range(size):
                if board[x][y].price != "not buyable" and board[x][y].owner != "no owner":
                    board[x][y].write()
        tk.update()
        firebase.put('/', 'Turn', (turn+1)%len(players))
        print("\n"*50)
    else:
        print("Veuillez patienter...")
        oldTurn = firebase.get('/Turn', None)
        while firebase.get('/Turn', None) == oldTurn:
            time.sleep(1)
        print("\n"*50)

