from tkinter import *
import random
import math
import time

tk = Tk()

#Generate canvas
canvasW = 800
canvasH = 800

tk.geometry(str(canvasW) + "x" + str(canvasH) + "+0+0")
tk.title("Professional")
canvas = Canvas(tk, width=canvasW, height=canvasH)
canvas.pack()

#Create diplomas
diplomas = {"CQP": [1, 500],
            "DEES": [1, 5000],
            "CAPES": [2, 750],
            "DSAA": [2, 750],
            "CAP": [2, 1000],
            "DEUST": [2, 1500],
            "DUT": [2, 1500],
            "DFASM": [8, 500]}

#Create News cards
#type price change   --> [nombre de joueurs, type de carte News, operation]
#type money transfer --> [nombre de joueurs, type de carte News, metier requis, montant a gagner/perdre]
cards = ([3, "Il n'y a plus de petrole. Les entreprises petrolieres ferment leurs portes. Votre revenu passe a $%d.", "price change", "DirecteurEntreprisePetroliereIncome*=0"],
         [2, "La fusion nucleaire marche officiellement et sera mise en place d'ici l'annee prochaine. Si vous etes scientifique, touchez $20000.", "money transfer", "Scientifique", 20000],
         [3, "Le terroriste Humis Berg a finalement ete retrouve. Les policiers touchent $2000.", "money transfer", "Policier", 2000],
         [2, "A cause de l'urbanisation, le prix moyen d'une location d'appartement a gravement augmente. Il represente aujourd'hui 1,5 fois plus qu'auparavant, ce qui fait $%d le mois.", "price change", "AgentImmobilierIncome*=1.5"],
         [2, "Nous sommes en pleine periode de vacances. A cause d'une hausse du tourisme, le prix moyen d'une nuit a l'hotel est multiplie par 1,5, ce qui fait $%d la nuit.", "price change", "HotelierIncome*=1.5"],
         [2, "La nourriture se fait rare a cause d'un manque d'eau. Les agriculteurs eleveurs vendent maintenant leurs produits 2 fois plus chers qu'avant. Ils coutent $%d.", "price change", "AgriculteurEleveurIncome*=2"],
         [2, "Il y a trop de candidats au poste de professeur. Le prix pour aller etudier est multiplie par 1,3. Tous les prix des formations sont multiplies par %d.", "price change", "ProfesseurIncome+=1.3"],
         [2, "Votre banquier vous ordonne de payer une dette que vous aviez faite durant votre jeunesse. Vous payez $5000.", "money transfer", "none required", -5000],
         [3, "Le gouvernement, pour empecher que les dirigeants de casino s'enrichissent trop, ordonne que tout ceux qui ont plus de deux casinos payent une amande de $8000.", "money transfer", "DirigeantCasino", -8000],
         [3, "Un grand virus s'est propage. Le gouvernement ordonne aux medecins de baisser leurs consultations de $100. Le cout pour se faire soigner fait donc maintenant $%d.", "price change", "MedecinChirurgienIncome-=100"],
         [2, "Il y a de plus en plus d'entrepreneurs. Il devient plus difficile de realiser ses projets. Tous les entrepreneurs doivent tomber %d fois sur le chiffre 7.", "price change", "EntrepreneurSameNumbers=6"],
         [2, "Attaque terroriste en Inde. Si vous etes journaliste, vous gagnez $2000 en plus de vos $1000 pour avoir fait ce scoop.", "money transfer", "Journaliste", 2000],
         [2, "A cause des dernieres attaques terroristes, les gens partent. Le prix moyen d'une location d'appartement diminue. Il baisse de $100. Il represente aujourd'hui $%d le mois.", "price change", "AgentImmobilierIncome-=100"],
         [2, "Le tourisme baisse legerement, le prix moyen d'une nuit a l'hotel diminue de $10. Il represente aujourd'hui $%d la nuit.", "price change", "HotelierIncome-=10"],
         [2, "Une nouvelle espece animal a ete decouverte. Si vous etes scientifique, touchez $10000.", "money transfer", "Scientifique", 10000],
         [3, "Il y a de moins en moins de malades. Les medecins augmentent leurs prix de $500 pour ne pas faire fallite. Vous devez maintenant payer $%d.", "price change", "MedecinChirurgienIncome+=500"],
         [3, "Un nouveau forage a detecter un gisement de petrole. Les entreprises petrolieres reprennent leurs activites. Vous vendez a nouveau votre petrole $%d.", "price change", "DirecteurEntreprisePetroliereIncome+=8000"],
         [2, "Si vous etes artiste, vous touchez $10000 d'un riche milliardaire qui veut decorer son manoir avec vos oeuvres.", "money transfer", "Artiste", 10000],
         [3, "Votre pere est mort. Vous touchez une partie de son heritage, ce qui fait que vous gagnez $15000.", "money transfer", "none required", 15000],
         [3, "Vous touchez $10000 de votre voiture que vous avez vendu.", "money transfer", "none required", 10000],
         [2, "Vous touchez $8000 de la lotterie.", "money transfer", "none required", 8000],
         [2, "Vous touchez $4000 de la lotterie.", "money transfer", "none required", 4000],
         [2, "Vous etes interviewer pour un documentaire. Touchez $1500.", "money transfer", "none required", 1500],
         [2, "Si vous etes entrepreneur et que vous avez deja realise un projet, vous venez d'avoir l'idee du siecle. Touchez $12000.", "money transfer", "Entrepreneur", 12000])

#Player class
class Player:
    def __init__(self, name):
        self.name = name
        self.money = 30000
        self.jailTime = 0
        self.jobs = []
        self.diplomas = []
        self.diplomaInFormation = []
        self.monthlyPayments = []

#Generate players
players = []

numberPlayers = 0

print("\n"*50)

while numberPlayers < 2 or numberPlayers > 4:
    numberPlayers = int(input("Nombre de joueurs : "))

for playerNumber in range(numberPlayers):
    while True:
        name = input("Nom du joueur %d : " % (playerNumber+1))
        if name == "":
            print("Vous n'avez pas rentre de nom.")
        elif len(name) > 8:
            print("Ce nom est trop long. Il doit faire maximum 8 characteres.")
        else:
            newName = True
            for player in players:
                if name == player.name:
                    print("Ce nom existe deja.")
                    newName = False
                    break
            if newName:
                break
    players.append(Player(name))

print("\n"*50)



#Squares classes
squareSize = 100

class Prison:
    def __init__(self):
        self.name = "Prison"
        self.price = "not buyable"
    def generate(self, x, y):
        self.photo = PhotoImage(file="img/prison.gif")
        canvas.create_image(x*squareSize, y*squareSize, anchor=NW, image=self.photo)
        canvas.create_rectangle(x*squareSize, y*squareSize, x*squareSize+squareSize, y*squareSize+squareSize, width=7)

class ArgentTrouve:
    def __init__(self):
        self.name = "Argent Trouve"
        self.price = "not buyable"
    def generate(self, x, y):
        self.photo = PhotoImage(file="img/argentTrouve.gif")
        canvas.create_image(x*squareSize, y*squareSize, anchor=NW, image=self.photo)
        canvas.create_rectangle(x*squareSize, y*squareSize, x*squareSize+squareSize, y*squareSize+squareSize, width=7)

class Tunnel:
    def __init__(self):
        self.name = "Tunnel"
        self.price = "not buyable"
    def generate(self, x, y):
        self.photo = PhotoImage(file="img/tunnel.gif")
        canvas.create_image(x*squareSize, y*squareSize, anchor=NW, image=self.photo)
        canvas.create_rectangle(x*squareSize, y*squareSize, x*squareSize+squareSize, y*squareSize+squareSize, width=7)

AgriculteurEleveurIncome = squareSize
class AgriculteurEleveur:
    def __init__(self):
        self.name = "Agriculteur Eleveur"
        self.price = 4000
        self.incomeType = "per customer"
        self.income = AgriculteurEleveurIncome
        self.diploma = "none required"
        self.owner = "no owner"
        self.star = False
    def generate(self, x, y):
        self.photo = PhotoImage(file="img/agriculteurEleveur.gif")
        canvas.create_image(x*squareSize, y*squareSize, anchor=NW, image=self.photo)
        canvas.create_rectangle(x*squareSize, y*squareSize, x*squareSize+squareSize, y*squareSize+squareSize, width=7)
    def update(self):
        self.income = AgriculteurEleveurIncome

ScientifiqueIncome = 50
class Scientifique:
    def __init__(self):
        self.name = "Scientifique"
        self.price = 600
        self.incomeType = "per customer"
        self.income = ScientifiqueIncome
        self.diploma = "DEUST"
        self.owner = "no owner"
        self.star = False
    def generate(self, x, y):
        self.photo = PhotoImage(file="img/scientifique.gif")
        canvas.create_image(x*squareSize, y*squareSize, anchor=NW, image=self.photo)
        canvas.create_rectangle(x*squareSize, y*squareSize, x*squareSize+squareSize, y*squareSize+squareSize, width=7)
    def update(self):
        self.income = ScientifiqueIncome

JournalisteIncome = 100
class Journaliste:
    def __init__(self):
        self.name = "Journaliste"
        self.price = 0
        self.incomeType = "by bank per customer"
        self.income = JournalisteIncome
        self.diploma = "DUT"
        self.owner = "no owner"
        self.star = False
    def generate(self, x, y):
        self.photo = PhotoImage(file="img/journaliste.gif")
        canvas.create_image(x*squareSize, y*squareSize, anchor=NW, image=self.photo)
        canvas.create_rectangle(x*squareSize, y*squareSize, x*squareSize+squareSize, y*squareSize+squareSize, width=7)
    def update(self):
        self.income = JournalisteIncome

AgentImmobilierIncome = 1500
class AgentImmobilier:
    def __init__(self):
        self.name = "Agent Immobilier"
        self.price = 15000
        self.incomeType = "per customer per month"
        self.income = AgentImmobilierIncome
        self.diploma = "DEUST"
        self.owner = "no owner"
        self.star = False
        self.customer = "no customer"
    def generate(self, x, y):
        self.photo = PhotoImage(file="img/agentImmobilier.gif")
        canvas.create_image(x*squareSize, y*squareSize, anchor=NW, image=self.photo)
        canvas.create_rectangle(x*squareSize, y*squareSize, x*squareSize+squareSize, y*squareSize+squareSize, width=7)
    def update(self):
        self.income = AgentImmobilierIncome

ProfesseurIncome = 1
class Professeur:
    def __init__(self):
        self.name = "Professeur"
        self.price = 0
        self.incomeType = "per customer per month by diploma"
        self.income = ProfesseurIncome
        self.diploma = "CAPES"
        self.owner = "no owner"
        self.star = False
    def generate(self, x, y):
        self.photo = PhotoImage(file="img/professeur.gif")
        canvas.create_image(x*squareSize, y*squareSize, anchor=NW, image=self.photo)
        canvas.create_rectangle(x*squareSize, y*squareSize, x*squareSize+squareSize, y*squareSize+squareSize, width=7)
    def update(self):
        self.income = ProfesseurIncome

HotelierIncome = 100
class Hotelier:
    def __init__(self):
        self.name = "Hotelier"
        self.price = 4000
        self.incomeType = "per customer by number"
        self.income = HotelierIncome
        self.diploma = "none required"
        self.owner = "no owner"
        self.star = False
    def generate(self, x, y):
        self.photo = PhotoImage(file="img/hotelier.gif")
        canvas.create_image(x*squareSize, y*squareSize, anchor=NW, image=self.photo)
        canvas.create_rectangle(x*squareSize, y*squareSize, x*squareSize+squareSize, y*squareSize+squareSize, width=7)
    def update(self):
        self.income = HotelierIncome

ArtisteIncome = 50
class Artiste:
    def __init__(self):
        self.name = "Artiste"
        self.price = 100
        self.incomeType = "per customer by number"
        self.income = ArtisteIncome
        self.diploma = "none required"
        self.owner = "no owner"
        self.star = False
    def generate(self, x, y):
        self.photo = PhotoImage(file="img/artiste.gif")
        canvas.create_image(x*squareSize, y*squareSize, anchor=NW, image=self.photo)
        canvas.create_rectangle(x*squareSize, y*squareSize, x*squareSize+squareSize, y*squareSize+squareSize, width=7)
    def update(self):
        if "DSAA" in self.owner.diplomas:
            self.income = ArtisteIncome*2
        else:
            self.income = ArtisteIncome

RestaurateurIncome = 100
class Restaurateur:
    def __init__(self):
        self.name = "Restaurateur"
        self.price = 1500
        self.incomeType = "per customer"
        self.income = RestaurateurIncome
        self.diploma = "none required"
        self.owner = "no owner"
        self.star = False
    def generate(self, x, y):
        self.photo = PhotoImage(file="img/restaurateur.gif")
        canvas.create_image(x*squareSize, y*squareSize, anchor=NW, image=self.photo)
        canvas.create_rectangle(x*squareSize, y*squareSize, x*squareSize+squareSize, y*squareSize+squareSize, width=7)
    def update(self):
        if "CQP" in self.owner.diplomas:
            self.income = RestaurateurIncome*2
        else:
            self.income = RestaurateurIncome

EntrepreneurIncome = 1500
EntrepreneurSameNumbers = 4
class Entrepreneur:
    def __init__(self):
        self.name = "Entrepreneur"
        self.price = 15000
        self.incomeType = "per customer after same numbers"
        self.income = EntrepreneurIncome
        self.entrepreneurSameNumbers = EntrepreneurSameNumbers
        self.sameNumbersTimes = 0
        self.diploma = "none required"
        self.owner = "no owner"
        self.star = False
    def generate(self, x, y):
        self.photo = PhotoImage(file="img/entrepreneur.gif")
        canvas.create_image(x*squareSize, y*squareSize, anchor=NW, image=self.photo)
        canvas.create_rectangle(x*squareSize, y*squareSize, x*squareSize+squareSize, y*squareSize+squareSize, width=7)
    def update(self):
        self.income = EntrepreneurIncome
        if "DEES" in self.owner.diplomas or "DUT" in self.owner.diplomas:
            self.entrepreneurSameNumbers = EntrepreneurSameNumbers/2
        else:
            self.entrepreneurSameNumbers = EntrepreneurSameNumbers/2

class News:
    def __init__(self):
        self.name = "News"
        self.price = "not buyable"
    def generate(self, x, y):
        self.photo = PhotoImage(file="img/news.gif")
        canvas.create_image(x*squareSize, y*squareSize, anchor=NW, image=self.photo)
        canvas.create_rectangle(x*squareSize, y*squareSize, x*squareSize+squareSize, y*squareSize+squareSize, width=7)

# Generate board
squares2Players = [Prison(),
                   Tunnel(), Tunnel(),
                   AgriculteurEleveur(), AgriculteurEleveur(),
                   Scientifique(), Scientifique(),
                   Journaliste(), Journaliste(),
                   AgentImmobilier(), AgentImmobilier(),
                   Professeur(), Professeur(),
                   ArgentTrouve(), ArgentTrouve(), ArgentTrouve(),
                   Hotelier(), Hotelier(), Hotelier(), Hotelier(),
                   Artiste(), Artiste(), Artiste(), Artiste(),
                   Restaurateur(), Restaurateur(), Restaurateur(), Restaurateur(),
                   Entrepreneur(), Entrepreneur(), Entrepreneur(), Entrepreneur(),
                   News(), News(), News(), News()]

squares3Players = []

squares4Players = []

if numberPlayers == 2:
    squares = squares2Players
elif numberPlayers == 3:
    squares = squares3Players
else:
    squares = squares4Players
random.shuffle(squares)

size = int(math.sqrt(len(squares)))

board = []
for y in range(size):
    board.append([])
    for x in range(size):
        n = y*size+x
        board[y].append(squares[n])
for y in range(size):
    for x in range(size):
        board[x][y].generate(x, y)
tk.update()

deck = []

year = 1
month = 1
week = 1
turn = 0

def moneyTransfer(winningPlayer, amount):
    player.money -= amount
    print("Vous avez maintenant $%d." % player.money)
    winningPlayer.money += amount
    print("%s a maintenant $%d." % (winningPlayer.name, winningPlayer.money))

def checkFormations():
    for player in players:
        if player.diplomaInFormation != []:
            if player.diplomaInFormation[2] == week and player.diplomaInFormation[3] == turn:
                player.diplomaInFormation[1] += 1
                if player.diplomaInFormation[1] > diplomas[player.diplomaInFormation[0]][0]:
                    player.diplomas.append(player.diplomaInFormation[0])
                    print("Vous avez obtenu le diplome %s" % player.diplomaInFormation[0])
                    player.diplomaInFormation = []
                else:
                    if player.diplomaInFormation[4] == "no owner":
                        player.money -= diplomas[diploma][1]
                        print("$%d a ete debite de votre compte banquaire pour votre formation. Il reste %d mois. Vous avez $%d." % (diplomas[diploma][1], diplomas[diploma][0]-player.diplomaInFormation[1]+1, player.money))
                    else:
                        if player == player.diplomaInFormation[4]:
                            print("Il reste %d mois de formation." % (diplomas[diploma][0]-player.diplomaInFormation[1]+1))
                        else:
                            print("Vous avez payez $%d a %s pour votre formation. Il reste %d mois." % (diplomas[diploma][1], player.diplomaInFormation[4].name, diplomas[diploma][0]-player.diplomaInFormation[1]+1))
                            moneyTransfer(player.diplomaInFormation[4], diplomas[diploma][1])

def checkMonthlyPayments():
    for player in players:
        for monthlyPayment in player.monthlyPayments:
            if monthlyPayment[2] == week and monthlyPayment[3] == turn:
                monthlyPayment[1] -= 1
                if monthlyPayment[1] == 0:
                    print("Vous avez finit de louer l'appartement de %s" % monthlyPayment[0].owner.name)
                    monthlyPayment[0].customer = "no customer"
                    player.monthlyPayments.remove(monthlyPayment)
                else:
                    print("Vous avez payez $%d a %s pour votre appartement." % (AgentImmobilierIncome, monthlyPayment[0].owner.name))
                    moneyTransfer(monthlyPayment[0].owner, AgentImmobilierIncome)

def checkEntrepreneur():
    for squareCoords in player.jobs:
        square = board[squareCoords[0]-1][squareCoords[1]-1]
        if square.name == "Entrepreneur":
            square.sameNumbersTimes += 1
            if square.sameNumbersTimes == square.entrepreneurSameNumbers:
                print("Vous avez realise un projet grace a votre case Entrepreneur %d,%d ! Vous touchez $10000." % (squareCoords[0], squareCoords[1]))
                player.money += 10000
                print("Vous avez maintenant $%d." % player.money)
            else:
                print("Votre projet de la case entrepreneur %d,%d est en train d'etre realise. Plus que %d fois des nombres pareilles et vous le realise." % (squareCoords[0], squareCoords[1], EntrepreneurSameNumbers-square.sameNumbersTimes))

def checkStar(squareToFind):
    squaresToFind = []
    for squareCoords in squareToFind.owner.jobs:
        square = board[squareCoords[0]-1][squareCoords[1]-1]
        if square.name == squareToFind.name:
            squaresToFind.append(square)
    if len(squaresToFind) >= 3:
        for squareCoords in squareToFind.owner.jobs:
            square = board[squareCoords[0]-1][squareCoords[1]-1]
            if square.name == squareToFind.name:
                newText = "* %s *" % player.name
                canvas.itemconfigure(square.text, text=newText)
                square.star = True
        tk.update()

def time():
    global year, month, week, turn 
    if turn == len(players):
        week += 1
        turn = 0
    if week > 5:
        month += 1
        week = 1
    if month > 12:
        year += 1
        month = 1
    print("Annee %d, mois %d, semaine %d du mois" % (year, month, week))
    print("C'est au tour de %s." % players[turn].name)
    checkFormations()
    checkMonthlyPayments()
    return players[turn]

def buySquare(squareX, squareY):
    x = squareX-1
    y = squareY-1
    square = board[x][y]
    price = square.price
    player.money -= price
    print("$%d a ete debite de votre compte banquaire. Vous avez $%d." % (square.price, player.money))
    square.owner = player
    player.jobs.append([squareX, squareY])
    canvas.create_rectangle(x*squareSize+squareSize*0.1, y*squareSize+squareSize*0.7, x*squareSize+squareSize*0.9, y*squareSize+squareSize*0.9, fill="black")
    square.text = canvas.create_text(x*squareSize+squareSize*0.5, y*squareSize+squareSize*0.8, text=player.name, fill="white", font=("Purisa", 14))
    tk.update()
    checkStar(square)
    print("Vous etes maintenant proprietaire de la case %s ayant les coordonnes %d,%d." % (square.name, squareX, squareY))

def startFormation():
    if player.diplomaInFormation != []:
        print("Vous avez deja le diplome %s en formation." % (player.diplomaInFormation[0]))
        return
    while True:
        diploma = input("Initiales du diplome : ")
        if diploma in player.diplomas:
            print("Vous avez deja le diplome %s." % player.diplomas[0])
        else:
            break
    if square.owner == "no owner":
        player.money -= diplomas[diploma][1]
        print("Vous commencez une formation de %d mois pour obtenir le %s. $%d sera debite chaque mois au cours de la formation." % (diplomas[diploma][0], diploma, diplomas[diploma][1]))
        print("Vous avez $%d." % player.money)
    else:
        if player == square.owner:
            print("Vous commencez une formation de %d mois pour obtenir le %s gratuite car vous etes professeur." % (diplomas[diploma][0], diploma))
        else:
            print("Vous commencez une formation de %d mois pour obtenir le %s. $%d sera paye a %s chaque mois au cours de la formation." % (diplomas[diploma][0], diploma, diplomas[diploma][1], square.owner.name))
            moneyTransfer(square.owner, diplomas[diploma][1])
    player.diplomaInFormation = [diploma, 1, week, turn, square.owner]

while True:
    player = time()
    if player.jailTime == 0:
        playerX = random.randint(1, 6)
        playerY = random.randint(1, 6)
        square = board[playerX-1][playerY-1]
        print("Vous etes sur la case %s ayant les coordonnes %d,%d." % (square.name, playerX, playerY))
        if playerX == playerY:
            checkEntrepreneur()
        if square.name == "Tunnel":
            while True:
                squareCoordsStr = input("Rentrez les coordonnees de la case ou vous voulez aller : ")
                squareCoords = list(map(int, squareCoordsStr.split(",")))
                playerX = squareCoords[0]
                playerY = squareCoords[1]
                square = board[playerX-1][playerY-1]
                if square.price == "not buyable":
                    print("Vous avez rentrez les coordonnees d'une case %s, mais ce n'est pas une case professions. Elle n'est donc pas reliee au reseau de tunnel.")
                else:
                    break
            print("Vous etes maintenant sur la case %s ayant les coordonnes %d,%d." % (square.name, playerX, playerY))
        if square.name == "Prison":
            player.jailTime = 3
            print("Vous etes prisonnie ! Vous devez rester en prison pendant 3 tours. Vous ne pourrez toucher de l'argent. Vous payez $500 d'amende.")
            player.money -= 500
            print("Vous avez maintenant $%d." % player.money)
        elif square.name == "Argent Trouve":
            amount = random.randrange(100, 3000, 100)
            print("Vous avez trouve $%d." % amount)
            player.money += amount
            print("Vous avez maintenant $%d." % player.money)
        elif square.name == "News":
            #Beginning getNews
            receivedNews = False
            while receivedNews == False:
                if len(deck) == 0:
                    for card in cards:
                        if card[0] <= numberPlayers:
                            deck.append(card)
                if len(deck) == 1:
                    news = deck[0]
                else:
                    news = random.choice(deck)
                if news[2] == "money transfer":
                    if news[3] == "none required":
                        print(news[1])
                        player.money += news[4]
                        print("Vous avez maintenant $%d." % player.money)
                        receivedNews = True
                    else:
                        for squareCoords in player.jobs:
                            square = board[squareCoords[0]-1][squareCoords[1]-1]
                            if news[3] == square.name:
                                if receivedNews == False:
                                    print(news[1])
                                player.money += news[4]
                                print("Vous avez maintenant $%d." % player.money)
                                receivedNews = True
                else:
                    exec(news[3])
                    newValue = eval(re.split(r'[`\-=~!@#$%^&*()_+\[\]{};\'\\:"|<,./<>?]', news[3])[0])
                    print(news[1] % newValue)
                    receivedNews = True
                deck.remove(news)
            #End getNews
        elif square.owner == "no owner":
            if square.diploma == "none required" or square.diploma in player.diplomas:
                answer = input("Voulez-vous acheter cette case ? ")
                if answer == "Oui" or answer == "oui":
                    buySquare(playerX, playerY)
            else:
                print("Pour devenir %s, vous avez besoin du diplome %s." % (square.name, square.diploma))
        else:
            if player == square.owner:
                print("Vous etes chez vous.")
            elif square.owner.jailTime != 0:
                print("%s est en prison, donc vous n'avez pas besoin de le payer." % square.owner.name)
            else:
                square.update()
                if square.star:
                    square.income *= 3
                if square.incomeType == "per customer":
                    print("Vous devez payer $%d a %s." % (square.income, square.owner.name))
                    moneyTransfer(square.owner, square.income)
                elif square.incomeType == "by bank per customer":
                    print("%s touche $%d car vous lui avez apporte des informations importantes." % square.owner.name)
                    square.owner.money += square.income
                    print("%s a maintenant $%d." % (square.owner.name, square.owner.money))
                elif square.incomeType == "per customer per month":
                    if square.customer == "no customer":
                        square.customer = player
                        months = random.randint(1, 6)
                        print("Vous devez payer $%d a %s chaque mois pendant %d mois pour votre appartement." % (square.income, square.owner.name, months))
                        moneyTransfer(square.owner, square.income)
                        square.owner.monthlyPayments.append([square, months, week, turn])
                elif square.incomeType == "per customer by number":
                    amount = random.randint(1, 10)*square.income
                    print("Vous devez payer $%d a %s." % (amount, square.owner.name))
                    moneyTransfer(square.owner, amount)
                elif square.incomeType == "per customer after same numbers":
                    if square.sameNumbersTimes >= 4:
                        print("Vous devez payer $%d a %s car son projet a ete realise." % (square.income, square.owner.name))
                        moneyTransfer(square.owner.name, square.income)
                    else:
                        print("%s n'a pas encore realise son projet, donc vous n'avez pas besoin de le payer." % square.owner.name)
        if square.name == "Professeur":
            startFormation()
    else:
        player.jailTime -= 1
        if player.jailTime > 0:
            print("Il vous reste %d tours de prison." % player.jailTime)
        else:
            print("Vous allez etre libere de prison au prochain tour.")
    input("Appuyez sur une touche pour terminer votre tour. ")
    print("\n"*50)
    turn += 1

