from tkinter import *
from tkinter import messagebox
from tkinter import simpledialog
import time
import random
import sys
import math

tk = Tk()
msg = messagebox
sdg = simpledialog

#Global variables
slotColor = "grey"
bgColor = "#99ccff"
canvasW = 750
canvasH = 750
squaresPerLine = 30
squareSize = canvasW/squaresPerLine
slotSize = squareSize*3
squares = [[]]

#Create canvas
tk.geometry(str(canvasW) + "x" + str(canvasH+int(slotSize)) + "+0+0")
tk.title("2D Craft")
canvas = Canvas(tk, width=canvasW, height=canvasH+slotSize, bg=slotColor)
canvas.pack()

sky = canvas.create_rectangle(0, 0, canvasW, canvasH, fill=bgColor)

world = []
zombies = []

inventory = ["none", "none", "none", "none", "none", "none", "none", "none", "none", "none"]
selectedSlot = 0
squaresDictionary = {
    #name:[drop, image, other]
    "grass":["dirt", PhotoImage(file="img/grass.gif"), ""],
    "dirt":["dirt", PhotoImage(file="img/dirt.gif"), ""],
    "sand":["sand", PhotoImage(file="img/sand.gif"), ""],
    "water":["replaceable", PhotoImage(file="img/water.gif"), "transparent"],
    "stone":["cobblestone", PhotoImage(file="img/stone.gif"), ""],
    "cobblestone":["cobblestone", PhotoImage(file="img/cobblestone.gif"), ""],
    "leaves":["undropeable", PhotoImage(file="img/leaves.gif"), ""],
    "wood":["wood", PhotoImage(file="img/wood.gif"), ""],
    "plank":["plank", PhotoImage(file="img/plank.gif"), ""],
    "door":["door", PhotoImage(file="img/door.gif"), "openable"],
    "lava":["replaceable", PhotoImage(file="img/lava.gif"), "transparent"],
    "iron_ore":["iron_ore", PhotoImage(file="img/iron_ore.gif"), ""],
    "iron_ingot":["unplaceable", PhotoImage(file="img/iron_ingot.gif"), ""],
    "iron_block":["iron_block", PhotoImage(file="img/iron_block.gif"), ""],
    "diamond_ore":["diamond", PhotoImage(file="img/diamond_ore.gif"), ""],
    "diamond":["unplaceable", PhotoImage(file="img/diamond.gif"), ""],
    "diamond_block":["diamond_block", PhotoImage(file="img/diamond_block.gif"), ""],
    "emerald_ore":["emerald", PhotoImage(file="img/emerald_ore.gif"), ""],
    "emerald":["emerald", PhotoImage(file="img/emerald.gif"), ""],
    "bedrock":["unmineable", PhotoImage(file="img/bedrock.gif"), ""],
    "none":["unmineable", PhotoImage(file="img/bedrock.gif"), ""]
}

craftingRecipes = {
    #itemwanted:[amountgiven, itemsrequired]
    "plank":[4, ["wood"]],
    "door":[3, ["plank", "plank", "plank", "plank", "plank", "plank"]],
    "diamond_block":[1, ["diamond", "diamond", "diamond", "diamond", "diamond", "diamond", "diamond", "diamond", "diamond"]],
    "iron_ingot":[1, ["iron_ore"]],
    "iron_block":[1, ["iron_ingot", "iron_ingot", "iron_ingot", "iron_ingot", "iron_ingot", "iron_ingot", "iron_ingot", "iron_ingot", "iron_ingot"]]
}

slots = []
for slot in range(10):
    inventoryX = slot*slotSize
    inventoryY = squaresPerLine*squareSize
    slots.append(canvas.create_rectangle(inventoryX, inventoryY, inventoryX+slotSize, inventoryY+slotSize))

class Player:
    def __init__(self, x, y, mainColor, outlineColor):
        self.photo = PhotoImage(file="img/player.gif")
        self.x = x
        self.y = y
        x *= squareSize
        y *= squareSize
        self.player = canvas.create_image(x, y, anchor=NW, image=self.photo)
    def move(self, x, y):
        amount = int(math.sqrt((y*5)**2))
        for animation in range(amount):
            canvas.move(self.player, 0, y*squareSize/amount)
            tk.update()
        self.y += y

player = Player(15, 5, "#ff0066", "#e6005c")

class Zombie:
    def __init__(self, x, y):
        self.photo = PhotoImage(file="img/zombie.gif")
        for zombie in zombies:
            if zombie.x == x and (zombie.y == y or zombie.y == y+1):
                canvas.delete(zombie.zombie)
                zombies.remove(zombie)
        self.x = x
        self.y = y
        x *= squareSize
        y *= squareSize
        zombies.append(self)
        self.previousMove = time.time()
        self.zombie = canvas.create_image(x, y, anchor=NW, image=self.photo)
    def move(self, x, y):
        amount = int(math.sqrt((y*5)**2))
        for animation in range(amount):
            canvas.move(self.zombie, 0, y*squareSize/amount)
            tk.update()
        canvas.move(self.zombie, x*squareSize, 0)
        self.x += x
        self.y += y

class Square:
    def __init__(self, x, y, name, chunk):
        self.name = name
        self.drop = squaresDictionary[name][0]
        photo = squaresDictionary[name][1]
        for square in chunk:
            if square.x == x and square.y == y:
                canvas.delete(square.square)
                world.remove(square)
        self.x = x
        self.y = y
        self.w = 1
        self.h = 1
        x *= squareSize
        y *= squareSize
        chunk.append(self)
        self.square = canvas.create_image(x, y, anchor=NW, image=photo)
    def move(self, x, y):
        canvas.move(self.square, x*squareSize, y*squareSize)
        self.x += x
        self.y += y

def generateTree(x, y):
    for vertical in range(3):
        for horizontal in range(5):
            Square(x-2+horizontal, y-3-vertical, "leaves", world)
        Square(x, y-vertical, "wood", world)
    for horizontal in range(3):
        Square(x-1+horizontal, y-6, "leaves", world)

def generatePond(x, y):
    Square(x, y-1, "sand", world)
    Square(x+6, y-1, "sand", world)
    for horizontal in range(5):
        Square(x+1+horizontal, y-1, "water", world)
    for horizontal in range(7):
        Square(x+horizontal, y, "sand", world)

def generateChunk(x):
    grassLevel = random.choice([True, False])
    dirtLevel = random.choice([True, False])
    tree = random.randint(1,30)
    pond = random.randint(1,30)
    if grassLevel:
        if tree == 1:
            generateTree(x, 6)
        Square(x, 7, "grass", world)
        Square(x, 8, "dirt", world)
    else:
        if tree == 1:
            generateTree(x, 7)
        Square(x, 8, "grass", world)
    for y in range(5):
        Square(x, y+9, "dirt", world)
    if dirtLevel:
        Square(x, 14, "stone", world)
    else:
        Square(x, 14, "dirt", world)
    if pond == 1:
        generatePond(x, 7)
    for y in range(14):
        lava = random.randint(1,5)
        iron_ore = random.randint(1,30)
        diamond_ore = random.randint(1,100)
        emerald = random.randint(1,200)
        if lava == 1 and y >= 10:
            Square(x, y+15, "lava", world)
        elif iron_ore == 1:
            Square(x, y+15, "iron_ore", world)
        elif diamond_ore == 1 and y >= 10:
            Square(x, y+15, "diamond_ore", world)
        elif emerald == 1 and y >= 10:
            Square(x, y+15, "emerald_ore", world)
        else:
            Square(x, y+15, "stone", world)
    Square(x, 29, "bedrock", world)
   
def move(x, y):
    move = True
    for square in world:
        if square.x+x == player.x and square.y == player.y and squaresDictionary[square.name][2] != "transparent" and squaresDictionary[square.name][2] != "openable":
            move = False
    if move:
        playerMove = False
        for square in world:
            if square.x+x == player.x and square.y == player.y+1 and squaresDictionary[square.name][2] != "transparent" and squaresDictionary[square.name][2] != "openable":
                playerMove = True
            if square.x == player.x and square.y == player.y-1 and squaresDictionary[square.name][2] != "transparent" and squaresDictionary[square.name][2] != "openable":
                move = False
            if square.x+x == player.x and square.y == player.y-1 and squaresDictionary[square.name][2] != "transparent" and squaresDictionary[square.name][2] != "openable":
                move = False
        if not playerMove:
            move = True
    if move:
        for zombie in zombies:
            if zombie.x+x == player.x and (zombie.y == player.y or zombie.y+1 == player.y or zombie.y == player.y+1 or zombie.y+1 == player.y+1):
                return
        for square in world:
            square.move(x, y)
        for zombie in zombies:
            zombie.move(x, y)
        if playerMove: 
            player.move(0, -1)

def moveMonsters(monster, x):
    move = True
    for square in world:
        if square.x-x == monster.x and square.y == monster.y and squaresDictionary[square.name][2] != "transparent":
            return
    monsterMove = False
    for square in world:
        if square.x-x == monster.x and square.y == monster.y+1 and squaresDictionary[square.name][2] != "transparent":
            monsterMove = True
        if square.x == monster.x and square.y == monster.y-1 and squaresDictionary[square.name][2] != "transparent":
            move = False
        if square.x-x == monster.x and square.y == monster.y-1 and squaresDictionary[square.name][2] != "transparent":
            move = False
    if not monsterMove:
        move = True
    if move:
        for zombie in zombies:
            if zombie.x-x == monster.x and (zombie.y == monster.y or zombie.y+1 == monster.y or zombie.y == monster.y+1 or zombie.y+1 == monster.y+1):
                return
        if player.x-x == monster.x and (player.y == monster.y or player.y+1 == monster.y or player.y == monster.y+1 or player.y+1 == monster.y+1):
            return
        if monsterMove: 
            monster.move(0, -1)
        monster.move(x, 0)

def drop(slot):
    inventory[slot][1] -= 1
    canvas.itemconfigure(inventory[slot][3], text=inventory[slot][1])
    if inventory[slot][1] == 1:
        canvas.itemconfigure(inventory[slot][3], text="")
    if inventory[slot][1] == 0:
        canvas.delete(inventory[slot][2])
        canvas.delete(inventory[slot][3])
        inventory[slot] = "none"

def collect(toCollect):
    occupiedSlots = []
    for slot in inventory:
        occupiedSlots.append(slot[0])
    if toCollect in occupiedSlots:
        inventory[occupiedSlots.index(toCollect)][1] += 1
        canvas.itemconfigure(inventory[occupiedSlots.index(toCollect)][3], text=inventory[occupiedSlots.index(toCollect)][1])
    else:
        x = inventory.index("none")*slotSize+squareSize
        y = inventoryY+squareSize
        photo = squaresDictionary[toCollect][1]
        inventory[inventory.index("none")] = [toCollect, 1, canvas.create_image(x, y, anchor=NW, image=photo), canvas.create_text(x+squareSize/2, y+squareSize/2, text="", fill="white", font=("Purisa", 25))]

def mine(event):
    x = math.floor(event.x/squareSize)
    y = math.floor(event.y/squareSize)
    if player.x-x >= 4 or player.x-x <= -4 or player.y-y >= 4 or player.y-y <= -5:
        return
    for square in world:
        if square.x == x and square.y == y:
            if square.drop == "unmineable" or square.drop == "replaceable":
                return
            if square.drop == "undropeable":
                canvas.delete(square.square)
                world.remove(square)
                return
            canvas.delete(square.square)
            collect(square.drop)
            world.remove(square)
            gravity(player)
            for zombie in zombies:
                gravity(zombie)

def place(event):
    if inventory[selectedSlot] == "none":
        return
    squaresList = []
    x = math.floor(event.x/squareSize)
    y = math.floor(event.y/squareSize)
    if player.x-x >= 4 or player.x-x <= -4 or player.y-y >= 4 or player.y-y <= -5 or (player.x == x and (player.y == y or player.y+1 == y)):
        return
    for zombie in zombies:
        if zombie.x == x and (zombie.y == y or zombie.y+1 == y):
            return
    for square in world:
        if square.x == x and square.y == y:
            if square.drop == "replaceable":
                canvas.delete(square.square)
                world.remove(square)
            else:
                return
    Square(x, y, inventory[selectedSlot][0], world)
    drop(selectedSlot)

def craft(event):
    toCraft = ""
    amountText = ""
    toCraft = simpledialog.askstring("Crafting Table", "What would you like to craft?")
    if toCraft not in craftingRecipes:
        return
    while not amountText.isdigit():
        amountText = simpledialog.askstring("Crafting Table", "How much time would you like to repeat this crafting?")
    amount = int(amountText)
    for times in range(amount):
        for square in craftingRecipes[toCraft][1]:
            occupiedSlots = []
            for slot in inventory:
                occupiedSlots.append(slot[0])
            if square not in occupiedSlots:
                return
            drop(occupiedSlots.index(square))
        for collection in range(craftingRecipes[toCraft][0]):
            collect(toCraft)

def gravity(thing):
    topSquare = Square(15, 100, "none", [])
    for square in world:
        if square.x == thing.x and square.y > thing.y+1 and square.y < topSquare.y and squaresDictionary[square.name][2] != "transparent":
            topSquare = square
    for zombie in zombies:
        if zombie.x == thing.x and zombie.y > thing.y+1 and zombie.y < topSquare.y:
            topSquare = zombie
    if player.x == thing.x and player.y > thing.y+1 and player.y < topSquare.y:
        topSquare = player
    thing.move(0, topSquare.y-(thing.y+2))

def atLight(thing):
    for square in world:
        if square.x == thing.x and square.y < thing.y:
            return False
    return True

def spawnMonsters():
    canSpawn = False
    x = random.randint(13, 19)
    y = random.randint(player.y-3, player.y+3)
    if player.x == x and (player.y == y or player.y+1 == y):
        return
    for square in world:
        if square.x == x and (square.y == y or square.y == y+1):
            return
        if square.x == x and square.y == y+2:
            canSpawn = True
    for zombie in zombies:
        if zombie.x == x and (zombie.y == y or zombie.y+1 == y):
            return
    if not canSpawn:
        return
    spawn = random.randint(0, 3)
    if spawn == 1:
        Zombie(x, y)

for x in range(300):
    generateChunk(x)
tk.update()

def left(event):
    move(1, 0)
    gravity(player)
    for zombie in zombies:
        gravity(zombie)
    tk.update()

def right(event):
    move(-1, 0)
    gravity(player)
    for zombie in zombies:
        gravity(zombie)
    tk.update()

def slot1(event):
    global selectedSlot
    selectedSlot = 0
def slot2(event):
    global selectedSlot
    selectedSlot = 1
def slot3(event):
    global selectedSlot
    selectedSlot = 2
def slot4(event):
    global selectedSlot
    selectedSlot = 3
def slot5(event):
    global selectedSlot
    selectedSlot = 4
def slot6(event):
    global selectedSlot
    selectedSlot = 5
def slot7(event):
    global selectedSlot
    selectedSlot = 6
def slot8(event):
    global selectedSlot
    selectedSlot = 7
def slot9(event):
    global selectedSlot
    selectedSlot = 8
def slot0(event):
    global selectedSlot
    selectedSlot = 9

r = 153
g = 204
b = 255
toggle = True
afternoon = True
oldTime = time.time()
day = True

while True:
    gravity(player)
    tk.bind("a", left)
    tk.bind("d", right)
    tk.bind("1", slot1)
    tk.bind("2", slot2)
    tk.bind("3", slot3)
    tk.bind("4", slot4)
    tk.bind("5", slot5)
    tk.bind("6", slot6)
    tk.bind("7", slot7)
    tk.bind("8", slot8)
    tk.bind("9", slot9)
    tk.bind("0", slot0)
    canvas.bind("<Button-1>", mine)
    canvas.bind("<Button-2>", place)
    tk.bind("c", craft)

    lastMove = time.time()
    if time.time()-lastMove >= 3:
        for zombie in zombies:
            if zombie.x < player.x:
                monsterMove(zombie, 1)
            elif zombie.x > player.x:
                monsterMove(zombie, -1)
            lastMove = time.time()
    
    if b == 255:
        toggle = True
        afternoon = True
    elif b == 0:
        toggle = True
        afternoon = False
    myColor = "#%02x%02x%02x" % (r, g, b)
    canvas.itemconfig(sky, fill=myColor) #change color
    
    if afternoon:
        if r > 0:
            r -= 1
        else:
            if toggle:
                day = False
                oldTime = time.time()
                toggle = False
        if g > 0:
            g -= 1
        b -= 1
        tk.update()
        time.sleep(0.03)
    else:
        if b >= 255-153:
            r += 1
            if toggle:
                day = True
                oldTime = time.time()
                toggle = False
        if b >= 255-204:
            g += 1
        b += 1
        tk.update()
        time.sleep(0.03)
    spawnMonsters()
    
    if day:
        for zombie in zombies:
            if atLight(zombie):
                canvas.delete(zombie.zombie)
                zombies.remove(zombie)
    for zombie in zombies:
            if time.time() - zombie.previousMove >= 1:
                if player.x > zombie.x:
                    moveMonsters(zombie, 1)
                if player.x < zombie.x:
                    moveMonsters(zombie, -1)
                zombie.previousMove = time.time()
            gravity(zombie)
#currentChunk = chunk1
#clear(chunk1)
#chunk2 = generateChunk()
